#include "mbed.h"
#include <vector>
#include "Utils.h"
#include "hci.h"
#include "ftclasslibusbdevbt.h"

//extern HCI* gHCI;
class application;
extern application App;

void printf(const BD_ADDR* addr);

void ftdev::receive(int socket, SocketState state, const u8* data, int len) {
    printf("ftdev::receive was called: socket %d, state=%d, length=%d\n", socket, state, len);
//    unsigned char req[] = "\xdget_ser_num\xd";
    unsigned char req[] = {0xbe, 0xef, 6, 0xfc, 0,0,0,0,0, 0xaf};
    if (len==0) {
        switch (state) {
            case SocketState_Opening:
                break;
            case SocketState_Open:
                printf("sending request \n%s\n", req);
                Socket_Send(sock, req, sizeof(req));
                break;
            case SocketState_Closing:
            case SocketState_Closed:
                return;
        }
    } else {
        //printHex(data, len);
        parse(data, len);
        if (state==SocketState_Open)
            ;//Socket_Close(sock);//replace with ft primitive
    }
}

unsigned short ftdev::chksum() {
    unsigned short sum = (X1_len & 0xFF) + (X1_len >> 8);
    for (int i = 0; i < X1_len; i++)
        sum += X1_pkt[i];
    return -sum;
}

void ftdev::parse (const unsigned char *buf, unsigned len) {
    unsigned i = 0;
    while (i < len) {
        char c = buf[i++];
        switch (parseState) {
            case 0: //ascii state
                if (c==2)
                    parseState = 1;
                else
                    putc(c, stdout);
                break;
            case 1:
                if (c==0x55)
                    parseState = 2;
                else {
                    parseState = 0;
                    printf("expected 0x55 in X1 header, found %02X\n", c);
                }
                break;
            case 2:
                X1_len = c<<8;
                parseState= 3;
                break;
            case 3:
                X1_len += c;
                parseState= 4;
                X1_pkt = new unsigned char[X1_len];
                X1_pos = 0;
                break;
            case 4:
                if  (X1_pos < X1_len) X1_pkt[X1_pos++] = c;
                else parseState = 5;
                break;
            case 5:
                X1_crc = c<<8;
                parseState= 6;
                break;
            case 6:
                X1_crc += c;
                parseState= 7;
                break;
            case 7:
                if (c == 3 && X1_crc == chksum()) {
                   //handlePkt();
                   printHex(X1_pkt, X1_len);
                }else
                    printf("framing or checksum error, end char = %02X\n", c);
                
                parseState = 0;
                break;
        }
    }
}

vector<ftbtdev*> ft_devs;
ftdev  _ftdev; //single instance, just for test

int GetNrOfFtBtDevices() {
    return ft_devs.size();
}

unsigned InitFtBtDeviceList() {//assume inquiry has been done
    static char FtDevClass[3] = {0x00, 0x1F, 0x82 };
    BTDevice* devs[8];
    int count = ((HCI*)&App)->GetDevices(devs,8);
    int n = 0;
    for (int i = 0; i < count; i++) {
        if (memcmp(devs[i]->_info.dev_class, FtDevClass, 3)==0) {
            ft_devs.push_back(new ftbtdev(&devs[i]->_info));
            printf("%d: %s\n", n++, devs[i]->_name);
        }
//        printf("device %d (handle=%d) ", i, devs[i]->_handle);
//        printfBytes("devclass: ", devs[i]->_info.dev_class, 3);
    }
    return n;
}

ftbtdev* GetFtUsbDeviceHandle(unsigned  Num) {
    if (Num < ft_devs.size()) {
        return ft_devs[Num];
    }
    return 0;
}

unsigned OpenFtBtDevice(ftbtdev* d) {
    BD_ADDR* bd = d->BtAddr();
    printf("Connecting to ");
    printf(bd);
    printf("\n");
    return _ftdev.Open(bd, 1); //TODO: everything can go wrong here
}
