#ifndef HEYBRD_H
#define KEYBRD_H
#include "mbed.h"
#include "MCP23017.h"

class keybrd{
public:
  enum event { none, keydown, keyup, posdown, posup };
  typedef void (*eventhandler)(event ev, char key);
private:
  eventhandler _eventhandler;
 // DigitalOut *inirq;  //for test only  
protected:
  MCP23017& _intf;
  InterruptIn *intr; //should be moved to MCP23017
  virtual void handler();
  char _keys;
  char _lastkey;
  event _lastevent;
  int _pos, _oldpos, _min, _max;
  char _state;
  bool wrap;
  void handleEvent(event ev, char key) { _lastevent = ev; if (_eventhandler) _eventhandler(ev, key); }  
public:
  keybrd(MCP23017& intf, PinName p);
  ~keybrd() { intr->fall(0); delete intr;}
  void attach(eventhandler eh) { _eventhandler = eh;}
  char getc() { return _lastkey;}
  int getpos() { return _pos>>2; }
  void setpos(int p) { _pos = p<<2;}
  void setposrange(int min, int max, bool w = false) { _min = min<<2; if (_pos<_min) _pos = _min; _max = max<<2; if (_pos>_max) _pos = _max; wrap = w;}
  event getevent(bool clear = false) { event e = _lastevent; if (clear) _lastevent = none; return e;}
  unsigned short get();
  unsigned short raw;//debug
};

#endif