#ifndef IPODCONTROL_H
#define IPODCONTROL_H
#include "ipod.h"

enum types { top, playlist=1, artist=2, album=3, genre=4, song=5, composer=6, podcast=8};
enum _mode { nav, playback, fastf, fastr, stopfast};

class ipodControl {
    static const int maxdepth = 5;
    static const char *toplevel[];
    static const types paths[][maxdepth];
    unsigned path, level;
    _mode  mode;
    unsigned items, current;
    unsigned last[maxdepth];
    unsigned elapsed, tracklength, newpos;
    unsigned status;
    ipod& pod;
    char *name;
    bool wrap;
    void Next() { current++; if (current == items) current = wrap ? 0 : items-1;}
    void Prev() { if (current == 0) current = wrap ? items-1 : 0; else current--;}
    enum { usIdle, usGet_time_status, usGet_title, usGet_artist, usStartPoll, usStopPoll} update_state;
protected:
    void updater(unsigned);
public:
    ipodControl(ipod& p) ;
//commands
    void OK() { OK(current);}
    void OK(unsigned item);
    void Menu();
    void Fwd() {pod.SendAirCmd(command, next);}
    void Rev() {pod.SendAirCmd(command, prev);}
    void PlayPause() {pod.SendAirCmd(command, play);}
    void Right();
    void Left();
    void MoveTo(float);
    bool readName();
    void StartPolling() { pod.SendAirCmd(polling, 1);}
    void Update(){update_state = usGet_time_status; pod.SendAirCmd(polling, 0); pod.SendAirCmd(get_time_status); printf("Update: getting status\n");}
//setters
    void setWrap(bool w=true) { wrap = w;}
//getters
    _mode getMode(){ return mode;}
    const char* getPathStr() const { return toplevel[path];}
    const char* getTypeStr() const { types t = paths[path][level]; if (t==top) return "Music"; return toplevel[t-1];}
    types getType() { return paths[path][level];}
    unsigned getItems() { return items;}
    unsigned getElapsed() { return elapsed;}
    unsigned getTrackLength() { return tracklength;}
    float getPos() { return (float)elapsed/(float)tracklength;}
//event processing
    void poll();
    void (*OnTitle)(const char*);
    void (*OnAlbum)(const char*);
    void (*OnArtist)(const char*);
    void (*OnGetNames)(unsigned, const char*);
    void (*OnTrackChange)(unsigned);
    void (*OnTime)(unsigned);
    void (*OnStatus)(unsigned, unsigned, unsigned);
    void (*OnError)(unsigned, unsigned);
};

#endif