#include "mbed.h"
#if 0
#include "async_i2c.h"

i2c_status async_i2c::write(char address, char *data, int size, bool stop){
    if (testbusy()) return i2c_busy;
    int result = 0;
    I2C::write(address & 0xFE, data, size, !stop);    // Write data to selected Register
    releasebusy(stop);
    if (_we) _we(result ? i2c_nack : i2c_ok, data, stop);
    return i2c_ok;
}

i2c_status async_i2c::read(char address, char *data, int size, bool stop){
    if (testbusy()) return i2c_busy;
    int result = I2C::read(address | 1, data, size, !stop);
    releasebusy();
    if (_re) _re(result ? i2c_nack : i2c_ok, data, stop);
    return i2c_ok;
}

void async_i2c::process(i2c_buffer *b){
  if (b->_adr & 1) //read
    I2C::read(b->_adr, b->_data, b->_size, _next==0);
  else
    I2C::write(b->_adr, b->_data, b->_size, _next==0);
}

i2c_buffer* async_i2c::write(char address, char *data, int size, bool copy, i2c_buffer *b){
    if (testbusy()) return 0;
    i2c_buffer *buf = new i2c_buffer(this, address & 0xFE, data, size, copy, b);
    int result = 0;
    //I2C::write(address & 0xFE, data, size, b==0);    // Write data to selected Register
    process(buf);
    //with still blocking io, the transmission is complete, in the future this piece should be in the callback
    buf->notify();
    return buf;
}

i2c_buffer* async_i2c::read(char address, char *data, int size, bool copy, i2c_buffer *b){
    if (testbusy()) return 0;
    i2c_buffer *buf = new i2c_buffer(this, address | 0x01, data, size, copy, b);
    process(buf);
    //with still blocking io, the transmission is complete, in the future this piece should be in the callback
    buf->notify();
    return buf;
}

i2c_buffer* async_i2c::read(char address, char reg, char *data, int size, bool copy){
    if (testbusy()) return 0;
    i2c_buffer *recv = new i2c_buffer(this, address | 0x01, data, size, copy);
    i2c_buffer *send = new i2c_buffer(this, address & 0xFE, &reg, sizeof(reg), true, recv);
    int result = 0;
    process(send);
    //with still blocking io, the transmission is complete, in the future this piece should be in the callback
    send->notify();
    return recv;
}
#endif
/*
void write_done(i2c_status s, char *, bool) { 
if (s == i2c_ok) {
  _stat = read();
}
}

i2c_status async_i2c::write_read(char address, char *wdata, int wsize, char *rdata, int rsize){
    write_end(write_done);
    return write(address, wdata, wsize, false);    // Write data to selected Register
}
*/
