#ifndef FADER_H
#define FADER_H
#include "motordriver.h"
#include "PID.h"
#include "filter.h"

extern AnalogIn Vmotor;
extern DigitalOut track;


class servo: public Motor {//class to control a DC motor with analog (potentiometer) feedback
    AnalogIn *fb;
    PID *pid;
    Ticker tick;
    float _setPoint;
    float _out;
    float deadband;
    bool coasting;
    float med;
    filter *flt;
protected:
    virtual void process();
    void reset() {
        pid->reset();
    }
    void update() {
        med = flt->process(*fb);
    }
public:
    servo(PinName p, PinName f, PinName r, PinName a);
    virtual ~servo() {
        delete pid;
        delete fb;
        delete flt;
    }
//setters
    virtual void set(float v) {
        _setPoint = v;
        pid->setSetPoint(v);
    printf("%f %%\n", v*100);
    }
//getters
    float pos() {
        //return *fb;
        return med;
    }
    float setPoint() {
        return _setPoint;
    }
    float output() {
        return _out;
    }
    bool isCoasting() {
        return coasting;
    }
};

class fader: public servo {
    float thres, thres2;
    int count;
    float lastpos;
    AnalogIn *touch;
    void (*command)(float);
    enum { holding, tracking, moving} state;
protected:
    virtual void process() ;
public:
    fader(PinName p, PinName f, PinName r, PinName a, PinName t=NC);
    virtual ~fader() {
        if (touch)
            delete touch;
    }
//setters
    virtual void set(float v) {
        if (state==moving)
            return; //cannot accept new value while wiper is being moved
        if (state==holding)
            reset(); //clear cummulative error after coasting
        state = tracking;//this is the only way to make the servo active again
        servo::set(v);
//    printf("%f%%\n", v*100);
        track = 0; //debug
    }
    void setOnMove(void(*f)(float)) {
        command = f;
    }
    void setMoveThreshold(float t) {
        thres = t;
    }
//getters
    //pos is inherited
};
#endif