#ifndef BUZZER_H
#define BUZZER_H
#include "MCP23017.h"

class buzzer {
    MCP23017& _intf;
    Timeout t;
    void stop() {
        char tmp = _intf.read(PORT_B);
        tmp &= ~BUZZ;
        _intf.write(PORT_B, tmp);
    }
public:
    buzzer(MCP23017& intf): _intf(intf) {
        intf.direction(PORT_B, INPUTS);// rot enc input
        intf.configurePullUps(PORT_B, INPUTS);
    }
    ~buzzer() {
        t.detach();
        stop();
    }
    void buzz(int ms) {
        char tmp = _intf.read(PORT_B);
        tmp |= BUZZ;
        _intf.write(PORT_B, tmp);
        t.attach_us(this, &buzzer::stop, ms*1000);
    }
};
#endif