#ifndef IPOD_H
#define IPOD_H

//#define TX_IRQ
#define DEBUGPIN    LED2

//enum types { top, playlist, artist, album, genre, song, composer, podcast, endoflist};
enum playback { play = 1, stop, next, prev, ffwd, frwd, stopf};
enum aircmd { get_ipod_size = 0x12, get_ipod_name = 0x14, switch_to_main = 0x16, switch_to_item = 0x17, get_count = 0x18, get_names = 0x1a, get_time_status = 0x1c,
              get_position = 0x1e, get_title = 0x20, get_artist = 0x22, get_album = 0x24, polling = 0x26, play_list = 0x28, command = 0x29,
              get_shuffle = 0x2c, set_shuffle = 0x2e, get_repeat = 0x2f, set_repeat = 0x31, get_nr_in_playlist = 0x35, jump_to_nr_in_playlist = 0x37, select = 0x38
            };

class ipod {
    union conv { int asInt;
        char asBytes[4];
    };
    void copy(char *b, union conv p) ;
    unsigned copy(char *b) ;
    Serial *com;
    void handlerx();
    void handletx();
    unsigned char state, length, mode, chk;
    volatile short command, lastcommand;
    char *rx_buffer, tx_buffer[16];
    char tx_size, tx_index;
    bool rx_ready, tx_ready;
    enum errors { err_success=0, err_timeout=1, err_failure=2, err_limit=4, err_answer=5, err_unknown}error;
    char *string; //just a pointer into rx_buffer
    unsigned arg1, arg2, arg3;
    volatile unsigned replies;
    DigitalOut &led;
protected:
    void write() {
        for (int i = 0; i < tx_size; i++)
            com->putc(tx_buffer[i]);
    }
public:
    ipod(PinName tx, PinName rx);
    ~ipod() {
        delete com;
    }
//commands
   void SendAirCmd(unsigned cmd, unsigned arg1=0, unsigned arg2=0, unsigned arg3=0);
   void guarded_SendAirCmd(unsigned cmd, unsigned arg1=0, unsigned arg2=0, unsigned arg3=0);
    void SetMode(int);
//event processing
    bool ready() {
        return rx_ready;
    }
    void release() {
        delete[] rx_buffer;
        rx_ready = false;
    }
    void parse();
    bool waitForReply();
//getters
    short cmd() {
        return command;
    }
    const char* text() const {
        return string;
    }
    unsigned Arg1() {
        return arg1;
    }
    unsigned Arg2() {
        return arg2;
    }
    unsigned Arg3() {
        return arg3;
    }
    errors getError() {
        return error;
    }
};
#endif