/*
Copyright (c) 2010 Peter Barrett

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "mbed.h"
#include "USBHost.h"
#include "Utils.h"
#include "ftlibclass.h"
#include "ftlibclassusb.h"
#include "ftlibclasstxc.h"
#include "ftlibclasstxcbt.h"
#include "neighbourhood.h"
#include "btserial.h"

class tx_emul {
    typedef void (*handler)(unsigned char *, int);
    int sock;
    unsigned char sndbuf[20], recbuf[20];
    int pos;
    int reclen, chksum;
    handler onMsg;
    void send(int len) {
        sndbuf[2] = len;
        sndbuf[len+3] = 0;
        for (int i = 2; i < len + 3; i++)
            sndbuf[len+3] += sndbuf[i];
        Socket_Send(sock, sndbuf, len+4);
        printfBytes("Sent msg:", sndbuf, len+4);
    }
    static void callback(int socket, SocketState state, const unsigned char *data, int len, void* userData) {
        tx_emul *self = (tx_emul*)userData;
        self->cb(socket, state, data, len);
    }
    void cb(int socket, SocketState state, const unsigned char *data, int len) {
        int i = 0;
        if (state == SocketState_Open)
            if (len > 0)
                while (i<len) {
                    switch (pos) {
                        case 0:
                            if (data[i] == 0xBE) pos = 1;
                            break;
                        case 1:
                            if (data[i] == 0xEF) pos = 2;
                            else pos = 0;
                            break;
                        case 2:
                            chksum = reclen = data[i];
                            break;
                        default:
                            if (pos < reclen+3) {
                                chksum += data[i];
                                recbuf[pos-3] = data[i];
                                pos++;
                            } else {
                                if (chksum==data[i]) {
                                    if (onMsg) onMsg(recbuf, reclen);
                                    printfBytes("BEEF msg:", recbuf, reclen);
                                } else
                                    printf("BEEF checksum error, should be %02x, got %02x\n", chksum, data[i]);
                                pos = 0;
                            }
                    }
                    i++;
                }
            else {
                const char *ack = "CONN_ACK";
                strcpy((char*)sndbuf+3, ack);
                send(strlen(ack));
                printf("Sent %s\n", ack);
            }
        else if (state == SocketState_Closed) {
            //reopen it again
            pos = 0;
            sock = Socket_Listen(SOCKET_RFCOM, 1,  callback, this);
        }
    }

public:
    tx_emul(handler h=0): onMsg(h) {
        sndbuf[0] = 0xBE;
        sndbuf[1] = 0xEF;
        pos = 0;
        sock = Socket_Listen(SOCKET_RFCOM, 1,  callback, this);
    }
    ~tx_emul() {
        Socket_Close(sock);
    }
    void sendMsg(unsigned char hwid, unsigned char subid, unsigned short cmd, unsigned short val) {
        sndbuf[3] = hwid;
        sndbuf[4] = subid;
        sndbuf[5] = cmd;
        sndbuf[6] = cmd>>8;
        sndbuf[7] = val;
        sndbuf[8] = val>>8;
        send(6);
    }
};

Serial pc(USBTX, USBRX);

FT_TRANSFER_AREA *ta = 0;
TA *tax = 0;
NOTIFICATION_EVENTS ne;

int main() {
    pc.baud(460800);
    printf("USBShell\nNow get a bunch of usb things and plug them in\n");
    USBInit();
    int state = 0;
    Timer time;
    time.start();
    int n, r0, r1, r2, r3=0;
    //    ftusbdev* h = 0;
    ftusbdevtxbt* h = 0;
    tx_emul *fttxbt = 0;
    printf("Start enumeration\n");
    for (;;) {
        switch (state) {
            case 0: //enumeration, allow 3 seconds
                if (time.read() >= 20) {
                    if (tx_emulation)
                        state = 10;
                    else
                        state = 1;
                    printf("Start initialisation\n");
                }
                break;
            case 1: //init program
                r0 = ftlib::InitFtLib();
                printf("InitFtLib() returns %d\n", r0);
                r1 = ftusbdevtxbt::InitFtUsbDeviceList();
                printf("InitFtUsbDeviceList() returns %d\n", r1);
                n = ftusbdev::GetNumFtUsbDevice();
                printf("GetNumFtUsbDevice() returns %d\n", n);
                for (int i = 0; i < n; i++) {
                    ftdev* h = ftusbdev::GetFtUsbDeviceHandle(i);
                    printf("handle = %p\n", h);
                    unsigned sn = h->GetFtSerialNr();
                    printf("S/N=%d\n", sn);
                    char *name = h->GetFtLongNameStrg();
                    printf("%d: %s SN=%08d\n", i, name, sn);
                    delete[] name;
                    //USBLoop();
                }
                h = dynamic_cast<ftusbdevtxbt*>(ftusbdev::GetFtUsbDeviceHandle(0));
                if (h==0) {
                    printf("Cast failed\n");
                    state = 4;
                    break;
                }
                r2 = h->OpenFtUsbDevice();
                printf("OpenFtUsbDevice() returns %08x\n", r2);
                //                ta = h->GetFtTransferAreaAddress();
                tax = h->GetFtTransferAreaAddress(0);
                r3 = h->StartFtTransferArea(&ne);
                if (r3) {
                    printf("Could not start thread %08X\n", r3);
                    state = 3;
                    break;
                }
                state = 2;
                printf("Start main loop\n");
                break;
            case 2: //main loop
                ftlib::poll();
                /*                if (ta->ChangeEg) {
                printf("%02X %d %d %d\n", ta->E_Main, ta->AX, ta->A1, ta->AV);
                ta->ChangeEg = 0;
                }*/
                //printf("%02X %d %d %d\r", tax->input.uni[0],tax->input.uni[1],tax->input.uni[2],tax->input.uni[3]);
                if (time.read() >= 30) {
                    state = 3;
                    printf("\nEnd of main loop\n");
                }
                break;
            case 3: //finalizing
                h->StopFtTransferArea();
                h->CloseFtDevice();
                ftlib::CloseFtLib();
                //neighbors->write(); //succeeds but nothing gets written
                state = 4;
                break;
            case 4:
                break;
            case 10://init tx emulation
                fttxbt = new tx_emul;
                state = 11;
                break;
            case 11:
                break;
            default:
                return 0;
        }
        USBLoop();
    }
}

int OnDiskInsert(int device) {
    return 0;
}

