#ifndef FTLIBCLASSCOM_H
#define FTLIBCLASSCOM_H

#include "ftlibclassdev.h"
#include <vector>

#define BAUDRATE_II 9600
#define BAUDRATE_RI 38400

#define usleep(x)    wait_us(x)
#define sleep(x)    wait(x)

class ftlib;

class ftcommdev: public ftdev { //for serial devices (Robo over Com), IIF devices are derived from this
    friend ftlib;
    virtual unsigned pgm_message(unsigned code, unsigned dwMemBlock);
protected:
    static vector<ftcommdev*> devs;
    Serial *device;
    unsigned port;
    int windex, rindex;
    ftcommdev() {}
    ftcommdev(Serial *s, unsigned t, unsigned c);
    static int write(Serial *d, unsigned char *ptr, int n, int timeout_ms);
    static int read(Serial *stream, unsigned char *buf, int n, int timeout_ms);
    int write();
    void writeByte();
    void readByte();
    static void onTick() {
        for (int i = 0; i < devs.size(); i++) devs[i]->trigger();
    }
    static void CloseAllFtDevices() {
        for (int i = 0; i < devs.size(); i++) devs[i]->CloseFtDevice();
    }
    virtual void FtThreadInit();
    virtual void FtThreadBegin();
//    virtual void FtThreadEnd();
    virtual void FtThreadFinish();
public:
    virtual ~ftcommdev() {
        if (port>0) delete device;
    }
    static void poll();
//public API: These functions match those of the original ftlib
    static ftcommdev* OpenFtCommDevice(unsigned dwPort, unsigned dwTyp, unsigned dwZyklus, unsigned *pdwError);
    static ftcommdev* OpenFtCommDevice(Serial *port, unsigned dwTyp, unsigned dwZyklus, unsigned *pdwError);
    virtual unsigned      CloseFtDevice();
    virtual unsigned      GetFtSerialNr();
    virtual char*     GetFtManufacturerStrg() {
        return strdup("Knobloch GMBH");
    }
    virtual char*     GetFtShortNameStrg();
    virtual char*     GetFtLongNameStrg();
    virtual unsigned  SetFtDistanceSensorMode(unsigned dwMode, unsigned dwTol1, unsigned dwTol2,
            unsigned dwSchwell1, unsigned dwSchwell2, unsigned dwRepeat1, unsigned dwRepeat2);
    /*
    virtual unsigned      GetFtDeviceSetting(FT_SETTING *pSet);
    virtual unsigned      SetFtDeviceSetting(FT_SETTING *pSet);
    */
    virtual unsigned StartFtProgram(unsigned dwMemBlock) {
        return pgm_message(0xf4, dwMemBlock);
    }
    virtual unsigned StopFtProgram() {
        return pgm_message(0xf8, 0);
    }
};

class ftcommdevii: public ftcommdev {//specialisation of intelligent interface like devices
    friend ftcommdev;
    int analogcycle, cycle;
    int ii_speed;
    ftcommdevii() {}
    ftcommdevii(Serial *s, unsigned t, unsigned c):ftcommdev(s, t, c), analogcycle(c) {
        cycle = 0;
        ii_speed = 0;
    }
    virtual void FtThreadBegin();
    virtual void FtThreadEnd();
};

#endif