#ifndef FTLIBCLASSTXC_H
#define FTLIBCLASSTXC_H
#include "ftlibclassusb.h"
#include <string.h>
#include "fifo.h"
#define FT_TXC  300


typedef unsigned char UINT8;
typedef unsigned char BOOL8;
typedef unsigned char UCHAR8;
typedef unsigned short  UINT16;
typedef short  INT16;
typedef unsigned short  BOOL16;
typedef int INT32;
typedef unsigned UINT32;

//#include "ROBO_TX_FW.h" //"../PC_programming_RoboTXC_V1-2_11_Dec_2009/PC_Programming_RoboTXC/Demo_Static_Lib_C/Inc/"
#include "ROBO_TX_FW_1_24.h" //"../PC_programming_RoboTXC/PC_Programming_RoboTXC/Demo_Static_Lib_C/Inc/"
typedef     struct {
    UINT32 snd, rec;
    UINT16 trans, session;
    UINT32 cmd, structs;
    } headerbody;
    
typedef struct {
    UINT16 start;
    union { //the message format is HL, the native format is LH, receiver routine swaps HL to LH, send routine writes as HL UINT16 bytes;
        struct {
            UINT8 bytesH, bytesL;
        }/*anonymous*/; //as_bytes;
        UINT16 bytes;
    };//winavr allows anonymous structs and unions
 headerbody body;
//    UINT32 ta_id;//ta_id is normally not considered part of the header but part of the payload, it is repeated for each struct
} header;


typedef struct {
    UINT16    chksum;
    UCHAR8    etx;
} trailer;

class ftusbdevtx: public ftusbdev {
    friend ftusbdev;
protected:
    typedef TA *pTA;
    pTA ta[TA_N_PARTS];
    unsigned short tid, sid;
    unsigned char *buffer;
    fifo console;
    unsigned active;
    unsigned short checksum(unsigned char *p, unsigned n);
    void getSlaveInfo();
    void (*cbRoboExtState)(unsigned, unsigned);
    ftusbdevtx();
    ftusbdevtx(int d);
    virtual void FtThreadInit() {
        busy = false;
    }
    virtual void FtThreadBegin() ;
    virtual void FtThreadEnd() ;
    virtual unsigned set_baudrate(unsigned br);
    void dump_buffer(int);
    //unsigned set_name(unsigned index, char *name) { return send_msg(9, 1<<index, name);}
    unsigned send_msg(unsigned cmd, unsigned set=0, bool sync = true);
    unsigned rec_msg();
    unsigned rec_msg2(headerbody *hdr, unsigned net_size);
    static void read_finished_cb(int device, int endpoint, int status, unsigned char* data, int len, void* userData);
    static void write_finished_cb(int device, int endpoint, int status, unsigned char* data, int len, void* userData);
    virtual int read_data(unsigned char *data, int size, USBCallback callback = 0, void* userData = 0) { return USBBulkTransfer(device, 0x82, data, size, callback, userData);}
    virtual int write_data(unsigned char *data, int size, USBCallback callback = 0, void* userData = 0) { return USBBulkTransfer(device, 0x03, data, size, callback, userData);}
public:
    virtual ~ftusbdevtx() {
        for (int i = 0; i < TA_N_PARTS; i++) if (ta[i]) {
                delete ta[i];
                ta[i]=0;
            }
    }
//public API: These functions match those of the original ftlib
    virtual unsigned OpenFtUsbDevice(); //ftxOpenComDevice, we regard a TXC as a USB device
    virtual unsigned CloseFtDevice(); //ftxCloseDevice, ftxCloseAllDevices (ftlibclass)
    virtual unsigned IsFtTransferActiv();
    virtual unsigned GetFtFirmware() {
        if (ta[0]) return ta[0]->info.version.firmware.abcd;
        return 0;
    }
    virtual unsigned GetFtSerialNr();
    virtual char*    GetFtManufacturerStrg() { //ftxGetManufacturerStrg
        return strdup("MSC Vertriebs GmbH");
    }
    virtual char*     GetFtShortNameStrg() {//ftxGetShortNameStrg
        return strdup("ROBO TX Controller");;
    }
    virtual char*     GetFtLongNameStrg();//ftxGetLongNameStrg
    virtual FT_TRANSFER_AREA*     GetFtTransferAreaAddress() {
#ifdef COMPATIBILITY
        if (ftdev::ta==0) ftdev::ta = new FT_TRANSFER_AREA;
#else
        printf("TXC does not support Robo TA\n");    //or create a compatible copy
#endif
        return ftdev::ta;
    }
    TA*  GetFtTransferAreaAddress(int i) ;
    virtual unsigned      StartFtTransferArea(NOTIFICATION_EVENTS* sNEvent );
    virtual unsigned      StartFtTransferAreaWithCommunication(NOTIFICATION_EVENTS* sNEvent ) {
        return FTLIB_ERR_NOT_SUPPORTED;
    }
//FtRemoteCmd
    void SetCBRoboExtState(void(*f)(unsigned, unsigned)) {
        cbRoboExtState = f;
    }
    unsigned GetRoboTxDevName(int dev, char *strbuf, int len) {
        if (ta[dev]==0) return 0;
        strncpy(strbuf, ta[dev]->info.device_name, len);
        return strlen(strbuf);
    }
    unsigned SetRoboTxDevName(int dev, char *strbuf) {
        if (ta[dev]==0) return FTLIB_ERR_DEVICE_NOT_OPEN;
        strncpy(ta[dev]->info.device_name, strbuf, 17);
        send_msg(9, 1<<dev);
        return FTLIB_ERR_SUCCESS;
    }
    unsigned GetRoboTxBtAddr(int dev, char *strbuf, int len) {
        if (ta[dev]==0) return 0;
        strncpy(strbuf, ta[dev]->info.bt_addr, len);
        return strlen(strbuf);
    }
    unsigned GetFirmware(int dev) {
        if (ta[dev]==0) return 0;
        return ta[dev]->info.version.firmware.abcd;
    }
    //unsigned GetRoboTxFwStr(char *strbuf, int len) { return sprintf(strbuf, "%010d", 123456789);}
    unsigned GetRoboTxHwStr(int dev, char *strbuf, int len) {
        if (ta[dev]==0) return 0;
        if (len>0) {
            *strbuf = ta[dev]->info.version.hardware.part.a;
            return 1;
        } else return 0;
    }
    unsigned GetRoboTxDllStr(int dev, char *strbuf, int len) {
        const char *dll = dev==0 ? "2" : "0";//seems to be '2' for master and '0' for slaves, source unknown
        strcpy(strbuf, dll);
        return strlen(dll);
    }
    unsigned SetOutCounterReset(int dev, unsigned cnt) {
        if (ta[dev]==0) return FTLIB_ERR_DEVICE_NOT_OPEN;
        if (cnt >= N_CNT) return -1;
        ta[dev]->output.cnt_reset[cnt] = true;
        return FTLIB_ERR_SUCCESS;
    }
    unsigned SetOutMotorValues(int dev, unsigned mId, float speed) {
        int dutyp = 0, dutym = 0;
        if (ta[dev]==0) return FTLIB_ERR_DEVICE_NOT_OPEN;
        if (mId >= N_MOTOR) return -1;
        if (speed >= 1) dutyp = 512;
        else if (speed >= 0) dutyp = 512*speed;
        else if (speed <= -1) dutym = 512;
        else dutym = 512*speed;
        ta[dev]->output.duty[mId<<1] = dutym;
        ta[dev]->output.duty[(mId<<1)+1] = dutyp;
        return FTLIB_ERR_SUCCESS;
    }
    unsigned SetOutPwmValues(int dev, unsigned mId, float speed) {
        int duty = 0;
        if (ta[dev]==0) return FTLIB_ERR_DEVICE_NOT_OPEN;
        if (mId >= N_PWM_CHAN) return -1;
        if (speed >= 1) duty = 512;
        else if (speed >= 0) duty = 512*speed;
        ta[dev]->output.duty[mId] = duty;
        return FTLIB_ERR_SUCCESS;
    }
    //SetFtUniConfig
    //SetFtCntConfig
    //SetMotorExConfig
    //StopMotorExConfig
    //ResetMotorExConfig
    //SetCBMotorExReached
    //GetInIOValue
    //GetInCounterValue
    //GetInDisplayButtonValue
    //SetRoboTxMessage
};

#endif

#if 0
class ta_txc: private TA {
public:
    unsigned GetRoboTxDevName(char *strbuf, int len) {
        strncpy(strbuf, info.device_name, len);
        return strlen(info.device_name);
    }
    unsigned SetRoboTxDevName(char *strbuf);
    unsigned GetRoboTxBtAddr(char *strbuf, int len) {
        strncpy(strbuf, info.bt_addr, len);
        return strlen(info.bt_addr);
    }
    unsigned GetRoboTxFwVal(unsigned *buf) {
        *buf = info.version.firmware.abcd;
        return 0;
    }
    //unsigned GetRoboTxFwStr(char *strbuf, int len) { return sprintf(strbuf, "%010d", 123456789);}
    unsigned GetRoboTxHwStr(char *strbuf, int len) {
        if (len>0) {
            *strbuf = info.version.hardware.part.a;
            return 1;
        } else return 0;
    }
    unsigned GetRoboTxDllStr(char *strbuf, int len) {
        char *dll ="0";
        strcpy(strbuf, dll);
        return strlen(dll);
    }
    //SetOutCounterReset
    //SetOutMotorValues
    //SetOutPwmValues
    //SetFtUniConfig
    //SetFtCntConfig
    //SetMotorExConfig
    //StopMotorExConfig
    //ResetMotorExConfig
    //SetCBMotorExReached
    //GetInIOValue
    //GetInCounterValue
    //GetInDisplayButtonValue
    //SetRoboTxMessage
};

class ftusbdevtx;
class ftdevtxslave {
    ftusbdevtx *mstr;
    int dev;
//protected:
    ftdevtxslave() {}
    ftdevtxslave(int d);
    //unsigned set_name(unsigned index, char *name) { return send_msg(9, 1<<index, name);}
public:
    virtual ~ftdevtxslave() { }
//public API: These functions match those of the original ftlib
    virtual unsigned GetFtFirmware() {
        if (ta[0]) return ta[0]->info.version.firmware.abcd;
        return 0;
    }
    virtual unsigned GetFtSerialNr();
    virtual char*    GetFtManufacturerStrg() { //ftxGetManufacturerStrg
        return strdup("MSC Vertriebs GmbH");
    }
    virtual char*     GetFtShortNameStrg() {//ftxGetShortNameStrg
        return GetFtLongNameStrg();
    }
    virtual char*     GetFtLongNameStrg();//ftxGetLongNameStrg
    virtual FT_TRANSFER_AREA*     GetFtTransferAreaAddress() {
#ifdef COMPATIBILITY
        if (ftdev::ta==0) ftdev::ta = new FT_TRANSFER_AREA;
#else
        printf("TXC does not support Robo TA\n");    //or create a compatible copy
#endif
        return ftdev::ta;
    }
    TA*  GetFtTransferAreaAddress(int i) ;
    //SetOutCounterReset
    unsigned SetOutMotorValues(int mId, float speed) {
        return mstr->SetOutMotorValues(dev, mId, speed);
    }
    //SetOutPwmValues
    //SetFtUniConfig
    //SetFtCntConfig
    //SetMotorExConfig
    //StopMotorExConfig
    //ResetMotorExConfig
    //SetCBMotorExReached
    //GetInIOValue
    //GetInCounterValue
    //GetInDisplayButtonValue
    //SetRoboTxMessage
};

#endif