#include "mbed.h"
#include "ftlib.h"
#include "ftlibclass.h"
#include "ftlibclasscom.h"
#include "ftlibclassusb.h"



ftlib* ftlib::lib = 0;

unsigned ftlib::InitFtLib() {
    lib = new ftlib;
    return FTLIB_ERR_SUCCESS;
}

void ftlib::onTick() {
    ftusbdev::onTick();
    ftcommdev::onTick();
}

void ftlib::poll() {
    ftusbdev::poll();    //this function should be called repetetively from the main event loop
    ftcommdev::poll();
}

unsigned ftlib::CloseFtLib() {
    delete lib;
    lib = 0;
    return FTLIB_ERR_SUCCESS;
}

unsigned ftlib::IsFtLibInit() {
    return lib ? FTLIB_ERR_LIB_IS_INITIALIZED : FTLIB_ERR_LIB_IS_NOT_INITIALIZED;
}

unsigned ftlib::CloseAllFtDevices() {
    ftusbdev::CloseAllFtDevices();
    ftcommdev::CloseAllFtDevices();
    return FTLIB_ERR_SUCCESS;
}

int ftlib::FtproductIDToInterfaceID(int iProductID) {
    switch (iProductID) {
        case ROBO_IF_PRODUCT_ID:
            return FT_ROBO_IF_USB;
        case EXT_IF_PRODUCT_ID:
            return FT_ROBO_IO_EXTENSION;
        case RF_DATA_LINK_PRODUCT_ID:
            return FT_ROBO_RF_DATA_LINK;
    }

    return 0;
}

char * ftlib::GetFtLibErrorString(unsigned dwErrorCode, unsigned dwTyp) {
    char *buffer = new char[128];

    switch (dwErrorCode) {
        case FTLIB_ERR_IF_NO_PROGRAM:
            if (dwTyp) strncpy(buffer, "There is no program stored to work with", 128);
            else strncpy(buffer, "FTLIB_ERR_IF_NO_PROGRAM", 128);
            break;
        case FTLIB_ERR_SUCCESS:
            if (dwTyp) strncpy(buffer, "Everything is fine", 128);
            else strncpy(buffer, "FTLIB_ERR_SUCCESS", 128);
            break;
        case FTLIB_ERR_THREAD_IS_RUNNING:
            if (dwTyp) strncpy(buffer, "Thread has been started successfully", 128);
            else strncpy(buffer, "FTLIB_ERR_THREAD_IS_RUNNING", 128);
            break;
        case FTLIB_ERR_DOWNLOAD:
            if (dwTyp) strncpy(buffer, "Failed to upload the program", 128);
            else strncpy(buffer, "FTLIB_ERR_DOWNLOAD", 128);
            break;
        case FTLIB_ERR_DOWNLOAD_WRONG_MEM_BLOCK:
            if (dwTyp) strncpy(buffer, "Bad target to upload the program to", 128);
            else strncpy(buffer, "FTLIB_ERR_DOWNLOAD_WRONG_MEM_BLOCK", 128);
            break;
        case FTLIB_ERR_INVALID_PARAM:
            if (dwTyp) strncpy(buffer, "A parameter specified has a wrong value", 128);
            else strncpy(buffer, "FTLIB_ERR_INVALID_PARAM", 128);
            break;
        case FTLIB_ERR_LIB_IS_INITIALIZED:
            if (dwTyp) strncpy(buffer, "This library has been initialized", 128);
            else strncpy(buffer, "FTLIB_ERR_LIB_IS_INITIALIZED", 128);
            break;
        case FTLIB_ERR_NOT_SUPPORTED:
            if (dwTyp) strncpy(buffer, "The requested action is not supported", 128);
            else strncpy(buffer, "FTLIB_ERR_NOT_SUPPORTED", 128);
            break;
        case FTLIB_ERR_PORT_NUMBER_IS_NULL:
            if (dwTyp) strncpy(buffer, "No handle given", 128);
            else strncpy(buffer, "FTLIB_ERR_PORT_NUMBER_IS_NULL", 128);
            break;
        case FTLIB_ERR_THREAD_NOT_RUNNING:
            if (dwTyp) strncpy(buffer, "Unable to start the thread", 128);
            else strncpy(buffer, "FTLIB_ERR_THREAD_NOT_RUNNING", 128);
            break;
        default:
            strncpy(buffer, "Unknown", 128);
    }

    return buffer;
}

