#ifndef MESSAGE_H
#define MESSAGE_H

template <class T, int N> class msgbuffer {
    T buffer[N];
    int in, out, n;
public:
    int push(T msg, int mode = 0);
    int nrOfMessages() {
        return n;
    }
    T pop();
    msgbuffer() {
        in = 0;
        out = 0;
        n = 0;
    }
    void clear() {
        in = 0;
        out = 0;
        n = 0;
    }
};

template <class T> bool operator==(T a, T b) {
    return memcmp(&a, &b, sizeof(T))==0;
}

template <class T, int N> int msgbuffer<T, N> ::push(T msg, int mode) {
    if (n>=N) return -1; //buffer full
    switch (mode) {
        case 2:
            for (int i = 0, j = out; i < n; i++, j++) {
                if (j >= N) j = 0;
                if (buffer[j] == msg)
                    return 0;
            }
            goto insert;
        case 1:
            if (buffer[in] == msg)
                return 0;
            goto insert;
        case 0:
insert:
            in++;
            if (in >= N) in = 0;
            buffer[in] = msg;
            n++;
            return 0;
    }
    return -2; //illegal option
}

template <class T, int N> T msgbuffer<T, N> ::pop() {
    T tmp = buffer[out++];
    if (out >= N)
        out = 0;
    return tmp;
}

#endif