#ifndef FTLIBCLASSUSB_H
#define FTLIBCLASSUSB_H

#include <vector>
#include "ftlibclassdev.h"

#define FT_VENDOR_ID 0x146a
#define ROBO_IF_PRODUCT_ID 0x1
#define EXT_IF_PRODUCT_ID 0x2
#define RF_DATA_LINK_PRODUCT_ID 0x3
/*
#define usleep(x)    wait_us(x)
#define sleep(x)    wait(x)
*/
class ftlib;

class ftusbdev: public ftdev {
    friend ftlib;
    virtual unsigned pgm_message(unsigned code, unsigned dwMemBlock);
protected:
    static vector<ftusbdev*> devs;
    int device; //usb device nr
    int rf; //rf call nr
    int usb_endpoint_read, usb_endpoint_write;
    ftusbdev() {}
    ftusbdev(int d, int t, int s = 0, int r = -1): ftdev(t, s), device(d), rf(r) {}
    static int GetNumFtDevicesFromRF(int device);
    static void onTick() {
        for (int i = 0; i < devs.size(); i++) devs[i]->trigger();
    }
    static void CloseAllFtDevices() {
        for (int i = 0; i < devs.size(); i++) devs[i]->CloseFtDevice();
    }
    static void read_finished_cb(int device, int endpoint, int status, unsigned char* data, int len, void* userData);
    static void write_finished_cb(int device, int endpoint, int status, unsigned char* data, int len, void* userData);
    virtual void FtThreadInit();
    virtual void FtThreadBegin();
//    virtual void FtThreadEnd();
    virtual void FtThreadFinish();
public:
    static void poll();
//public API: These functions match those of the original ftlib
    static unsigned InitFtUsbDeviceList();
    static unsigned GetNumFtUsbDevice() {
        return devs.size();
    }
    virtual unsigned OpenFtUsbDevice();
    static ftusbdev* GetFtUsbDeviceHandle(unsigned DevNr);
    static ftusbdev* GetFtUsbDeviceHandleSerialNr(unsigned dwSN, unsigned dwTyp);
    unsigned      SetFtDeviceCommMode (unsigned dwMode, unsigned dwParameter, unsigned short *puiValue);
    virtual unsigned      CloseFtDevice();
    virtual unsigned      GetFtFirmware();
    virtual char*     GetFtManufacturerStrg();
    virtual char*     GetFtShortNameStrg();
    virtual char*     GetFtLongNameStrg();
    virtual unsigned      SetFtDistanceSensorMode(unsigned dwMode, unsigned dwTol1, unsigned dwTol2,
            unsigned dwSchwell1, unsigned dwSchwell2, unsigned dwRepeat1, unsigned dwRepeat2);
    /*
    virtual unsigned      GetFtDeviceSetting(FT_SETTING *pSet);
    virtual unsigned      SetFtDeviceSetting(FT_SETTING *pSet);
    */
    virtual unsigned StartFtProgram(unsigned dwMemBlock) {
        return pgm_message(0x12, dwMemBlock);
    }
    virtual unsigned StopFtProgram() {
        return pgm_message(0x13, 0);
    }
};

class ftusbdevext: public ftusbdev {
    friend ftusbdev;
    ftusbdevext() {}
    ftusbdevext(int d, int t, int s): ftusbdev(d, t, s) {}
    virtual void FtThreadInit();
    virtual void FtThreadEnd();
};

#endif
