#ifndef FIFO_H
#define FIFO_H

class fifo {
    char *buf;
    int size, in, out, free;//free is nr of empty places, in is first empty place, out is first occupied place
//    fifo() {}
public:
    fifo(int sz = 127):size(sz), in(0), out(0), free(sz) {
        buf = new char[sz];
    }
    ~fifo() {
        delete[] buf;
    }

    void put(char c) {
        if (free) {
            buf[in++] = c;
            if (in==size) in = 0;
            free--;
        } else
            printf("fifo full\n");
    }

    int get() {
        if (free == size)
            return -1;
        free++;
        int c = buf[out++];
        if (out == size) out = 0;
        return c;
    }
    int gets(char *line, int len) {
       int i = out, n = size-free, l = 0;
       while (n>0 && buf[i] != '\n' && l<len-1) {
         if (buf[i] != '\r')
           line[l++] = buf[i++];
         else
           i++; //skip the \r
         if (i==size) i = 0;
         n--;
       }
       if (n==0) //buf does not contain EOLN
         return -1;
       if (buf[i] == '\n') {
         line[l] = '\0';
         out = i+1;
         if (out==size) out = 0;
         free = size - n + 1;
         return 0; //success
       } else //line too short
         return -2;
    }
    void flush() {
      free = size;
      in = 0;
      out = 0;
    }
};

#endif