#include "btserial.h"

btserial::btserial(char ba[6], char ch) {
    L2CAPAddr a;
    memcpy(&a.bdaddr, ba, 6);
    a.psm = ch;
    sendptr = 0;
    recptrin = 0;
    recptrout = bufsize - 1;
    free = bufsize;
    sock = Socket_Open(SOCKET_RFCOM, &a.hdr,  cb, this);
}

btserial::btserial(char ch) {
    sendptr = 0;
    recptrin = 0;
    recptrout = bufsize - 1;
    free = bufsize;
    sock = Socket_Listen(SOCKET_RFCOM, ch,  cb, this);
}

void btserial::cb(int socket, SocketState state, const unsigned char *data, int len, void* userData) {
    btserial *self = (btserial*)userData;
    if (state == SocketState_Open)
        if (len > 0)
            self->stash(data, len);
        else {
            //Socket_GetOpt(sock, SO_RECBUF, &recbufsize, sizeof(recbufsize));
            //Socket_GetOpt(sock, SO_SNDBUF, &sndbufsize, sizeof(sndbufsize));
            port_settings ps;//defaults are ok
            ps.baud = 3; //9600 baud
            ps.bits = 3;//8 bits
            ps.stop = 0;//1 bit
            ps.par = 0; //no parity
            ps.mask = MASK_BITRATE|MASK_DATABITS|MASK_STOPBITS|MASK_PARITYBITS;
            //set_remote_port_parameters(sock, &ps);
            self->open = true;
        }
        else if (state == SocketState_Closed)
          self->open = false;
}

void btserial::stash(const unsigned char *data, int len) {
    int i = 0;
    while (i < len && free>0) {
        recbuf[recptrin++] =  data[i++];
        if (recptrin == bufsize) recptrin = 0;
        free--;
    }
}

int btserial::getc() {
    if (free == bufsize || !open)
        return -1;
    free++;
    recptrout++;
    if (recptrout == bufsize) recptrout = 0;
    return recbuf[recptrout];
}

int btserial::putc(int c) {
    if (sendptr==bufsize || !open)
        return -1;
    sendbuf[sendptr++] = c;
    if (sendptr==bufsize || c=='\n' || c=='\r') {
        Socket_Send(sock, sendbuf, sendptr);
        sendptr = 0;
    }
    return c;
}

void btserial::baud(int br) {
    int rates[] = {2400,4800,7200,9600,19200,38400,57600,115200,230400};
    if (!open) return;
    for (int i = 0; i < sizeof(rates)/sizeof(int);i++)
        if (rates[i] == br) {
            port_settings ps;
            ps.baud = i;
            ps.mask = MASK_BITRATE;
            set_remote_port_parameters(sock, &ps);
            return;
        }
    printf("Illegal baudrate requested %d\n", br);
}

void btserial::format(int bits, Serial::Parity par, int stop) {
if (!open) return;
    port_settings ps;
    ps.bits = bits-5;
    ps.stop = stop-1;
    switch (par) {
        case Serial::None:
            ps.par = 0;
            ps.par_t = 0;
            break;
        case Serial::Odd:
            ps.par = 1;
            ps.par_t = 0;
            break;
        case Serial::Even:
            ps.par = 1;
            ps.par_t = 1;
            break;
        case Serial::Forced0:
            ps.par = 1;
            ps.par_t = 3;
            break;
        case Serial::Forced1:
            ps.par = 1;
            ps.par_t = 2;
            break;
    }
    ps.mask = MASK_DATABITS|MASK_STOPBITS|MASK_PARITYBITS|MASK_PARITYTYPE;
    set_remote_port_parameters(sock, &ps);
}

