#ifndef FTUSB_H
#define FTUSB_H
#include "USBHost.h"
#include <vector>
#include "hci.h"

struct _ftdev {
    int device;
    int product;
    int serial;
    int rf;
    _ftdev(int d, int p, int s, int r=-1): device(d), product(p), serial(s), rf(r) {}
};

extern vector<_ftdev> devs;
/*
unsigned InitFtUsbList (void);
_ftdev& GetFtUsbDevice(int n);
_ftdev* GetFtUsbDevicePtr(int n);
int GetUsbDeviceSerialNr(unsigned s, unsigned t=0);
unsigned int GetNthFtDeviceFromRF(int Num, int iRf);
*/
void OnLoadFtDevice(int device, DeviceDescriptor* deviceDesc, InterfaceDescriptor* interfaceDesc);
int OnBluetoothInsert(int device);


class BTApp : public HCI {
    BTDevice* devs[8];
    int count, i, pending;
public:
    void ConnectionComplete(connection_info* info) ;
    void ConnectDevices();
    virtual void Callback(HCI_CALLBACK_EVENT c, const u8* data, int len);
    int csr_write_bd_addr(BD_ADDR *bdaddr, bool transient=true);
    int csr_reset_device(bool transient=true);
};

extern BTApp Bluetooth;
extern bool tx_emulation;
#endif
