#ifndef FTLIBCLASS_H
#define FTLIBCLASS_H

#include "mbed.h"

#define LIBFT_VERSION_MAJOR 1
#define LIBFT_VERSION_MINOR 0
#define LIBFT_VERSION_PATCH 0

#define INTERFACE_QUERY_TIME 10000 // &#65533;s == 5ms


class ftusbdev;
class ftcommdev;

class ftlib {
    friend ftusbdev;
    friend ftcommdev;
    static ftlib* lib;
    Ticker tick;//the ticker indicates the moments that transfers should be conducted
    void onTick();
    ftlib() {
        tick.attach_us(this, &ftlib::onTick, INTERFACE_QUERY_TIME);
    }
    ~ftlib() {
        tick.detach();
    }
    static int FtproductIDToInterfaceID(int iProductID);
public:
    static void poll();
//public API: These functions match those of the original ftlib
    static unsigned GetLibVersion();
    static unsigned InitFtLib();
    static unsigned CloseFtLib();
    static unsigned IsFtLibInit();
    static char* GetFtLibErrorString(unsigned dwErrorCode, unsigned dwTyp);
    static unsigned CloseAllFtDevices() ;
};

#endif
