/*
OPN3-L Lib for mbed by Hyper-b
2016/01/12

このプログラムは
YMF288変換基板+Arduinoで簡易S98プレーヤを作る（その1）（http://d.hatena.ne.jp/m_yanase/20130901/1378020818）
を参考にしています。
*/


#include "mbed.h"
#ifndef __FMOPN__
#define __FMOPN__
class FMOPN
{
public:
    // D0 - 7 RST A0 A1 CS WR RD
    FMOPN(
        PinName _D0,
        PinName _D1,
        PinName _D2,
        PinName _D3,
        PinName _D4,
        PinName _D5,
        PinName _D6,
        PinName _D7,
        PinName RST,
        PinName A0,
        PinName A1,
        PinName CS,
        PinName WR,
        PinName RD
    );

    // Reset
    void reset();

    // Write
    // ifadr 0x00 A1 = 0
    // ifadr 0x01 A1 = 1
    // adr Address
    // dat Data
    void reg_write(unsigned char ifadr, unsigned char adr, unsigned char dat);
//    unsigned char reg_read(unsigned char ifadr, unsigned char adr);
    
    void adr_write(unsigned char ifadr, unsigned char adr);
    void dat_write(unsigned char dat);
//    unsigned char dat_read();

private:

    BusInOut _BUS;
    DigitalOut _RST;
    DigitalOut _A0;
    DigitalOut _A1;
    DigitalOut _CS;
    DigitalOut _WR;
    DigitalOut _RD;

    void law_write(unsigned char ifadr, unsigned char adr, unsigned char dat);

    static const int WT_FM_DA     = 25;  // min:24us FM Address 0x28
    static const int WT_FM_DB     = 2;   // min:1.9us FM Address 0x20-0xB6
    static const int WT_SSG_D     = 2;   // min:1.9us SSG Address 0x00-0x0F
    static const int WT_RHYTHM_DA = 22;  // min:22us RHYTHM Address 0x10
    static const int WT_RHYTHM_DB = 2;   // min:1.9us RHYTHM Address 0x11-0x1D
};

#endif
