#include "mbed.h"
#include "FMOPN.h"
#define bitRead(value, bit) (((value) >> (bit)) & 0x01)
FMOPN::FMOPN(
    PinName _D0,
    PinName _D1,
    PinName _D2,
    PinName _D3,
    PinName _D4,
    PinName _D5,
    PinName _D6,
    PinName _D7,
    PinName RST,
    PinName A0,
    PinName A1,
    PinName CS,
    PinName WR,
    PinName RD
) : _BUS(_D0,_D1,_D2,_D3,_D4,_D5,_D6,_D7), _RST(RST), _A0(A0), _A1(A1), _CS(CS), _WR(WR), _RD(RD)
{
}

// Reset
void FMOPN::reset()
{
    _RST = 0;
    wait_us(100);
    _RST = 1;
    wait_ms(100);
}


// Register Write
void FMOPN::reg_write(unsigned char ifadr, unsigned char adr, unsigned char dat)
{
    law_write(ifadr, adr, dat);
    switch (adr) {     // データライト後のWait
        case 0x28: {     // FM Address 0x28
            wait_us(WT_FM_DA);     // min: 24us wait
            break;
        }
        case 0x10: {     // RHYTHM Address 0x10
            wait_us(WT_RHYTHM_DA);     // min: 22us wait
            break;
        }
        default: {     // Other Address
            wait_us(2);     // min.1.9us wait
        }
    }
}
////Read
//unsigned char FMOPN::reg_read(unsigned char ifadr, unsigned char adr)
//{   
//    DigitalOut LED(LED1,1);
//    _BUS.output();
//    _WR = 0;
//    _RD = 1;
//    adr_write(ifadr,adr);
//    _BUS.input();
//    _WR = 1;
//    _RD = 0;
//    unsigned char dar=dat_read();
//    return dar;
//}

//Write
void FMOPN::law_write(unsigned char ifadr, unsigned char adr, unsigned char dat)
{   
    _BUS.output();
    _WR = 0;
    _RD = 1;
    adr_write(ifadr,adr);
    dat_write(dat);

}

//Write Address
void FMOPN::adr_write(unsigned char ifadr, unsigned char adr)
{
    _A0 = 0;     // Address Bus set
    _A1 =  bitRead(ifadr, 0);
    _BUS = adr;         // Address set
    _CS = 0;
    wait_us(1);     //  min: 200ns wait
    _CS = 1;
    wait_us(2);     //  min: 1.9us wait
}

//Write Data
void FMOPN::dat_write(unsigned char dat)
{
    _A0 = 1;     // Address Bus set
    _BUS = dat;         // Data set
    _CS = 0;
    wait_us(1);     //  min: 200ns wait
    _CS = 1;
}
////Read Data
//unsigned char FMOPN::dat_read()
//{
//    _A0 = 1;     // Address Bus set
//    _CS = 0;
//    unsigned char d=_BUS;
//    _CS = 1;
//    return d;
//}
