#include "mbed.h"
#include "C12832.h"

C12832 lcd(SPI_MOSI, SPI_SCK, SPI_MISO, p8, p11);
AnalogIn pot(p15);

static char Chat[] = {
0x20, 0x01, 0xe0, 0xf0, 0x00, 0x00, // XX_XXXXX, XXXXXXX_, ___XXXXX, _____XXX, XXXXXXXX, XXXXXXXX, 
0x30, 0x03, 0xc1, 0xe3, 0xfe, 0x00, // XX__XXXX, XXXXXX__, __XXXXX_, ___XXX__, _______x, XXXXXXXX, 
0x18, 0x03, 0xff, 0xf7, 0xff, 0x00, // XXX__XXX, XXXXXX__, ________, ____X___, ________, XXXXXXXX, 
0x0c, 0x0f, 0xff, 0xef, 0xc1, 0x80, // XXXX__XX, XXXX____, ________, ___X____, __XXXXX_, _XXXXXXX, 
0x18, 0x1f, 0xff, 0xfb, 0x99, 0xc0, // XXX__XXX, XXX_____, ________, _____X__, _XX__XX_, __XXXXXX, 
0x0c, 0x3f, 0xff, 0xfc, 0xc1, 0xe0, // XXXX__XX, XX______, ________, ______XX, __XXXXX_, ___XXXXX, 
0x18, 0x7f, 0xff, 0xfe, 0xff, 0xe0, // XXX__XXX, X_______, ________, _______X, ________, ___XXXXX, 
0x18, 0x7f, 0xff, 0xf8, 0xff, 0xe0, // XXX__XXX, X_______, ________, _____XXX, ________, ___XXXXX, 
0x0c, 0xff, 0xff, 0xe7, 0xff, 0xe0, // XXXX__XX, ________, ________, ___XX___, ________, ___XXXXX, 
0x03, 0xff, 0xff, 0xdf, 0xc1, 0xe0, // XXXXXX__, ________, ________, __X_____, __XXXXX_, ___XXXXX, 
0x00, 0x3f, 0xff, 0xe7, 0x99, 0xc0, // XXXXXXXX, XX______, ________, ___XX___, _XX__XX_, __XXXXXX, 
0x00, 0x0f, 0xfe, 0xfd, 0xc1, 0x80, // XXXXXXXX, XXXX____, _______X, ______X_, __XXXXX_, _XXXXXXX, 
0x00, 0x1f, 0x00, 0x1e, 0xff, 0x00, // XXXXXXXX, XXX_____, XXXXXXXX, XXX____X, ________, XXXXXXXX, 
0x00, 0x3c, 0x00, 0x7c, 0x00, 0x00, // XXXXXXXX, XX____XX, XXXXXXXX, X_____XX, XXXXXXXX, XXXXXXXX, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // XXXXXXXX, XXXXXXXX, XXXXXXXX, XXXXXXXX, XXXXXXXX, XXXXXXXX, 
};

Bitmap bitmChat = {
    48, //XSize
    15, //Ysize
    6,  //Bytes in Line
    Chat , //pointer to picture data
};

static char Mishi[] = {
0x20, 0x0f, 0x03, 0xe0, 0x00, 0x00, // XX_XXXXX, XXXX____, XXXXXX__, ___XXXXX, XXXXXXXX, XXXXXXXX, 
0x30, 0x07, 0xc0, 0x73, 0xfe, 0x00, // XX__XXXX, XXXXX___, __XXXXXX, X___XX__, _______X, XXXXXXXX, 
0x18, 0x03, 0xff, 0xf7, 0xff, 0x00, // XXX__XXX, XXXXXX__, ________, ____X___, ________, XXXXXXXX, 
0x0c, 0x0f, 0xff, 0xef, 0xc1, 0x80, // XXXX__XX, XXXX____, ________, ___X____, __XXXXX_, _XXXXXXX, 
0x18, 0x1f, 0xff, 0xfb, 0x99, 0xc0, // XXX__XXX, XXX_____, ________, _____X__, _XX__XX_, __XXXXXX, 
0x0c, 0x3f, 0xff, 0xfc, 0xc1, 0xe0, // XXXX__XX, XX______, ________, ______XX, __XXXXX_, ___XXXXX, 
0x18, 0x7f, 0xff, 0xfe, 0xff, 0xe0, // XXX__XXX, X_______, ________, _______X, ________, ___XXXXX, 
0x18, 0x7f, 0xff, 0xf8, 0xff, 0xe0, // XXX__XXX, X_______, ________, _____XXX, ________, ___XXXXX, 
0x0c, 0xff, 0xff, 0xe7, 0xff, 0xe0, // XXXX__XX, ________, ________, ___XX___, ________, ___XXXXX, 
0x03, 0xff, 0xff, 0xdf, 0xc1, 0xe0, // XXXXXX__, ________, ________, __X_____, __XXXXX_, ___XXXXX, 
0x00, 0x3f, 0xff, 0xe7, 0x99, 0xc0, // XXXXXXXX, XX______, ________, ___XX___, _XX__XX_, __XXXXXX, 
0x00, 0x0f, 0xfe, 0xfd, 0xc1, 0x80, // XXXXXXXX, XXXX____, _______X, ______X_, __XXXXX_, _XXXXXXX, 
0x00, 0x1f, 0x00, 0x38, 0xff, 0x00, // XXXXXXXX, XXX_____, XXXXXXXX, XX___XXX, ________, XXXXXXXX, 
0x00, 0x07, 0xc0, 0x1f, 0x00, 0x00, // XXXXXXXX, XXXXX___, __XXXXXX, XXX_____, XXXXXXXX, XXXXXXXX, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // XXXXXXXX, XXXXXXXX, XXXXXXXX, XXXXXXXX, XXXXXXXX, XXXXXXXX, 
};

Bitmap bitmMishi = {
    48, //XSize
    15, //Ysize
    6,  //Bytes in Line
    Mishi , //pointer to picture data
};

int main() {
    
    int place;
    
    while(1){
    
    place = 127*pot.read();
    
    lcd.cls();
    lcd.print_bm(bitmChat, place, 10);
    lcd.copy_to_lcd();
    wait(.3);
    lcd.print_bm(bitmMishi, place, 10);
    lcd.copy_to_lcd();
    wait (.3);
    
    }   
}