#include "MicroBit.h"

const int DATA_ID = MICROBIT_ID_NOTIFY+1; // last defined eventId is MICROBIT_ID_NOTIFY==1023 in MicroBitComponent.h 
const int NEW_DATA = 1;

MicroBit uBit;

int seconds = 0, minutes= 43, hours=16,currentHour=0;
ManagedString AMPM;

void ticker()
{
 while(1)
 {
    seconds++;
    uBit.sleep(1000);
    if (seconds==60)
    {
        seconds = 0;
        minutes++;  
    }
    if (minutes==60)
    {
       minutes=0;
       hours++;
    }
    if (hours==24)
    {
        hours = 0;
    }
    if (hours>12)
    {
       currentHour = hours - 12;
       AMPM = "PM";
    }
    else 
    {
       AMPM = "AM";
    }
       MicroBitEvent(DATA_ID,NEW_DATA);
 }   
}

void timeDisplay(MicroBitEvent evt)
{
uBit.display.setBrightness(250);
 uBit.display.scrollAsync(ManagedString(currentHour)+":"+ManagedString(minutes)+ManagedString(AMPM),80);
 }
    
int main()
{
    uBit.init();
    uBit.messageBus.listen(DATA_ID,NEW_DATA,timeDisplay);
    
    create_fiber(ticker);
    release_fiber();
}

