#include "mbed.h"       //ああああ
#include "PID.h"
#include "USBHostMSD.h"
#include "QEI.h"

//1回転あたりのパルス
#define PULSE_PER_REVOLUTION 200
//PIDのウェイト ミリ秒
#define PID_RATE 10

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
DigitalIn dip1(p5);
DigitalIn dip2(p6);
DigitalIn dip3(p7);
DigitalIn dip4(p8);
DigitalIn startsw(p9);
DigitalOut buzzer(p18);     //電子ブザー用デジタル出力
AnalogIn volume(p20);
PwmOut pwm(p21);


Timer timer;                //タイマー

int DIPled(){       //DIPスイッチの状態によってledを光らせる関数
    if(dip1 == 1) led1 = 1;
    else led1 = 0;
    if(dip2 == 1) led2 = 1;
    else led2 = 0;
    if(dip3 == 1) led3 = 1;
    else led3 = 0;
    if(dip4 == 1) led4 = 1;
    else led4 = 0;
    return 0;
}

int SW(){        //スタートスイッチ用関数，押して離したらスタート
    int i = 0, j = 0;
    while(i < 3){       //チャタリング除去，15msにわたってスタートスイッチが押されていればbreak
        if(startsw == 1){
            i++;
        }else{
            i = 0;
        }
        DIPled();
        wait_ms(5);
    }
    while(j < 3){       //上に同じ，スタートスイッチが離されたことを検知
        if(startsw == 0){
            j++;
        }else{
            j = 0;
        }
        DIPled();
        wait_ms(5);
    }
    return 0;
}

int main() {
    float vol = 0;
    DIPled();
    USBHostMSD msc("usb");
    while(1) {
        SW();
        vol = 1.0 - volume;
        buzzer = 1;
        wait(0.1);
        buzzer = 0;
        wait(0.1);
        buzzer = 1;
        wait(2*vol);
        buzzer = 0;
        
    }
}
