#include "mbed.h"
#include "QEI.h"

#define PULSE_PER_REVOLUTION 200

/**************************入出力ポート設定**************************/
DigitalOut led1(LED1);      //mbed上LED出力4つ
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
DigitalIn dip1(p5);         //DIPスイッチの入力4つ
DigitalIn dip2(p6);
DigitalIn dip3(p7);
DigitalIn dip4(p8);
DigitalIn startsw(p9);      //スタートスイッチ入力
DigitalOut buzzer(p18);     //電子ブザー用デジタル出力
AnalogIn volume(p20);       //ポテンショメータ入力(アナログ)
PwmOut pwm(p21);            //モータへのPWM出力

Serial pc(USBTX, USBRX);    //PCとのシリアル通信設定
QEI encoder(p25, p25, NC, PULSE_PER_REVOLUTION, QEI::X2_ENCODING);        //QEIの設定．エンコーダ出力がA相しかないのでどちらもp25
Timer timer;                //タイマー

/**************************プロトタイプ宣言**************************/
int Init();
int DipLed();
int GetDipValue();
int SW();
int Buzzer(int buzvar);

/**************************main文**************************/
int main() {
    //初期化
    Init();             //初期化関数
    int flag = 0;       //フラグ用変数
    float vol = 0;      //ポテンショメータからの入力値を受け取る変数
    float rpm = 0;      //rpmを格納するための変数
    float t = 0;        //時間計測のための変数
    //メインループ
    while(1){
        SW();           //スタートスイッチの入力を待つ
        flag = GetDipValue();   //DIPスイッチの入力を見る
        DipLed();               //DIPスイッチのHLでLEDを光らせる
        Buzzer(1);      //ブザーを鳴らす．
        switch (flag){      //実験モード切り替えのswitch文．ここにcase0~15を書き足せばモードが追加できる．
            case 0:     //DIPスイッチの入力なしで何もしない
                break;
            case 1:{        //モード1はポテンショメータからの入力で直接PWMのデューティ比を変更する．約1秒ごとにPCに値を出力する．このモードは時間で終了せず永遠に続く．終了するにはmbedのresetボタンを押す．
                int i1 = 0;
                timer.start();
                while(1){
                    vol = 1 - volume;
                    pwm = vol;
                    if(i1 >= 20){
                        timer.stop();
                        t = timer.read();
                        rpm = encoder.getRevolutions() * 60.0 / t;
                        pc.printf("Duty Ratio = %.2f , %5d RPM\n", vol, (int)rpm);
                        encoder.reset();
                        i1 = 0;
                        timer.reset();
                        timer.start();
                    }
                    wait_ms(50);
                    i1++;
                }
                break;
            }
            case 2:         //モード2はモータの応答を調べる．デューティ比1でモータを回転させ，経過時間とRPMをUSBメモリのcsvファイルに出力する．15秒で終了する．
                break;
            case 3:         //モード3はモータの応答を調べる．PID制御をかけ，経過時間とRPMをUSBメモリのcsvファイルに出力する．15秒で終了する．
                break;
            default:        //0と上以外でなにもなし
                break;
        }
    }
}

/**************************関数たち**************************/
int Init(){         //初期化関数
    pc.baud(57600);
    encoder.reset();
    timer.reset();
    pwm.period_us(100);
    DipLed();
    return 0;
}

int DipLed(){       //DIPスイッチの状態によってledを光らせる関数
    if(dip1 == 1) led1 = 1; else led1 = 0;     //DIPスイッチの1がHならLEDを光らせる,Lなら光らせない
    if(dip2 == 1) led2 = 1; else led2 = 0;
    if(dip3 == 1) led3 = 1; else led3 = 0;
    if(dip4 == 1) led4 = 1; else led4 = 0;
    return 0;
}

int GetDipValue(){  //DIPスイッチの値を取得し，値を返す関数
    int Dip1 = dip1, Dip2 = dip2, Dip3 = dip3, Dip4 = dip4; //DIPスイッチの値を取得
    if(Dip1 == 0){
        if(Dip2 == 0){
            if(Dip3 == 0){
                if(Dip4 == 0) return 0; else return 1;      //DIPスイッチが0000の場合0を返す．0001なら1
            }else{
                if(Dip4 == 0) return 2; else return 3;
            }
        }else{
            if(Dip3 == 0){
                if(Dip4 == 0) return 4; else return 5;
            }else{
                if(Dip4 == 0) return 6; else return 7;
            }
        }
    }else{
        if(Dip2 == 0){
            if(Dip3 == 0){
                if(Dip4 == 0) return 8; else return 9;
            }else{
                if(Dip4 == 0) return 10; else return 11;
            }
        }else{
            if(Dip3 == 0){
                if(Dip4 == 0) return 12; else return 13;
            }else{
                if(Dip4 == 0) return 14; else return 15;
            }
        }
    }
}

int SW(){        //スタートスイッチ用関数，押して離したらスタート
    int i = 0, j = 0;
    while(i < 3){       //チャタリング除去，15msにわたってスタートスイッチが押されていればbreak
        if(startsw == 1) i++;
        else i = 0;
        DipLed();
        wait_ms(5);
    }
    while(j < 3){       //上に同じ，スタートスイッチが離されたことを検知
        if(startsw == 0) j++;
        else j = 0;
        DipLed();
        wait_ms(5);
    }
    return 0;
}

int Buzzer(int buzvar){     //電子ブザーを鳴らす関数
    switch (buzvar){
        /**************エラーを知らせるbeep**************/
        case -1:        //error * - - - -
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1);
            buzzer = 1; wait(0.3); buzzer = 0; wait(0.3);
            buzzer = 1; wait(0.3); buzzer = 0; wait(0.3);
            buzzer = 1; wait(0.3); buzzer = 0; wait(0.3);
            buzzer = 1; wait(0.3); buzzer = 0; wait(0.3);
            break;
        /**************エラーここまで**************/
        case 0:         //サウンドなし
            buzzer = 0;
            break;
        /**************状態を知らせるためのbeep**************/
        case 1:         // *(短)
            buzzer = 1; wait(0.1); buzzer = 0;
            break;
        case 2:         // * *
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.05);
            buzzer = 1; wait(0.1); buzzer = 0;
            break;
        case 3:         // -(長)
            buzzer = 1; wait(0.3); buzzer = 0;
            break;
        case 4:         // - -
            buzzer = 1; wait(0.3); buzzer = 0; wait(0.3);
            buzzer = 1; wait(0.3); buzzer = 0;
            break;
        case 5:         // ---
            buzzer = 1; wait(0.9); buzzer = 0;
            break;
        case 6:         // * * *  * * *  * * *  *
            for(int i = 0; i < 3; i++){
                for(int j = 0; j < 3; j++){
                    buzzer = 1; wait(0.1); buzzer = 0; wait(0.1);
                }
                wait(0.2);
            }
            buzzer = 1; wait(0.1); buzzer = 0;
            break;
        case 7:         // **-* ** -* ** *** **** "finish"
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            buzzer = 1; wait(0.3); buzzer = 0; wait(0.1); 
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            wait(0.2);
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            wait(0.2);
            buzzer = 1; wait(0.3); buzzer = 0; wait(0.1); 
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            wait(0.2);
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            wait(0.2);
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            wait(0.2);
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            buzzer = 1; wait(0.1); buzzer = 0;
            break;
        case 8:         // *-*** -*- --* "オワリ"
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1);
            buzzer = 1; wait(0.3); buzzer = 0; wait(0.1);
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            wait(0.2);
            buzzer = 1; wait(0.3); buzzer = 0; wait(0.1); 
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            buzzer = 1; wait(0.3); buzzer = 0; wait(0.1); 
            wait(0.2);
            buzzer = 1; wait(0.3); buzzer = 0; wait(0.1); 
            buzzer = 1; wait(0.3); buzzer = 0; wait(0.1); 
            buzzer = 1; wait(0.1); buzzer = 0;
            break;
        /**************状態を知らせるためのbeepここまで**************/
        default:        //no sound
            buzzer = 0;
            break;
    }
    return 0;
}