#include "mbed.h"
#include "ADXL345_I2C.h"

//センサの校正値(要変更)
#define SENSOR1X 4.756
#define SENSOR1Y 2.557
#define SENSOR1Z -25.941

#define SENSOR2X 9.133
#define SENSOR2Y 1.428
#define SENSOR2Z -32.222
 
//LED1からLED4をled1からled4に割り当てる。
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

DigitalOut buzzer(p18);      //電子ブザー用アナorデジ出力

DigitalIn startsw(p21);
 
//ADXL345 accelerometer(p5, p6, p7, p8);
ADXL345_I2C accelerometer1(p9, p10);
ADXL345_I2C accelerometer2(p28, p27);
Serial pc(USBTX, USBRX);
LocalFileSystem local("local");

Timer timer;

int SW();        //スタートスイッチ用関数，押して離したらスタート
int Buzzer(int buzvar = 1);     //電子ブザーを鳴らす関数

int main(){
    
    int ledv=1; //led value初期化
    /*int data1[3] = {0, 0, 0};
    int data2[3] = {0, 0, 0};*/
    int data[2][3] = {};
    double tempdata[2][3] = {};
    double pfdata[2][3] = {};
    double kousei[2][3] = {{SENSOR1X, SENSOR1Y, SENSOR1Z}, {SENSOR2X, SENSOR2Y, SENSOR2Z}};
    const int n = 10;       //ループ回数
    //time_t tnow;
    //char buf[32];
    char filename[64];
    FILE *fp, *fpname;
    int fpn = 0;
    
    /* 
    pc.printf("Starting ADXL345 test...\n");
    pc.printf("Device1 ID is: 0x%02x\n", accelerometer1.getDevId());
    pc.printf("Device2 ID is: 0x%02x\n", accelerometer2.getDevId());
    */
 
    //Go into standby mode to configure the device.
    accelerometer1.setPowerControl(0x00);
    accelerometer2.setPowerControl(0x00);
 
    //Full resolution, +/-16g, 4mg/LSB.
    accelerometer1.setDataFormatControl(0x0B);
    accelerometer2.setDataFormatControl(0x0B);
     
    //3.2kHz data rate.
    accelerometer1.setDataRate(ADXL345_3200HZ);
    accelerometer2.setDataRate(ADXL345_3200HZ);
 
    //Measurement mode.
    accelerometer1.setPowerControl(0x08);
    accelerometer2.setPowerControl(0x08);
    
    wait(1);
    
    Buzzer(3);
    
    while(1){
    
        SW();
        Buzzer(1);
        wait(1);
        timer.reset();
        timer.start();
        
        /*
        ///////////////////////////////////////////
        while(1){
            
            for(int i = 0; i < 2; i++){
                for(int j = 0; j < 3; j++){
                    tempdata[i][j] = 0;
                }
            }
            
            wait(0.1-0.01*n);
            
            for(int i = 0; i < n; i++){
                accelerometer1.getOutput(data[0]);
                accelerometer2.getOutput(data[1]);
                
                for(int j = 0; j < 2; j++){
                    for(int k = 0; k < 3; k++){
                        tempdata[j][k] += (int16_t)data[j][k];
                    }
                }
                wait_ms(10);
            }
            
            for(int i = 0; i < 2; i++){
                for(int j = 0; j < 3; j++){
                    pfdata[i][j] = tempdata[i][j] / n - kousei[i][j];
                }
            }
            
            pc.printf("(%.2f,%.2f,%.2f),(%.2f,%.2f,%.2f)\n", pfdata[0][0],pfdata[0][1],pfdata[0][2],pfdata[1][0],pfdata[1][1],pfdata[1][2]);
            
        }*/
        
        //////////////////////////////////ここからファイル名の決定
        fpname = fopen("/local/fn.txt", "r");
        if(fpname == NULL){
            for(int i = 0; i < 5; i++){
                led1 = !led1;
                led2 = !led2;
                led3 = !led3;
                wait(1);
            }
            return -1;
        }
        fscanf(fpname,"%d",&fpn);
        fclose(fpname);
        fpname = fopen("/local/fn.txt","w");
        if(fpname == NULL){
            for(int i = 0; i < 5; i++){
                led1 = !led1;
                led2 = !led2;
                wait(1);
            }
            return -1;
        }
        fprintf(fpname,"%d",fpn+1);
        fclose(fpname);
        //////////////////////////////////////ここまでファイル名の決定
        /*tnow = time(NULL) + (60*60*9);
        strftime(buf,sizeof(buf),"%H%M%S", localtime(&tnow));
        sprintf(filename,"/local/lg%s.csv",buf);
        strftime(buf,sizeof(buf),"%Y-%m-%d %H:%M:%S", localtime(&tnow));*/
        /////////////////////////////////ここから出力ファイルを開く
        sprintf(filename,"/local/log%003d.csv",fpn);
        fp = fopen(filename,"w");
        if(fp == NULL){
            for(int i = 0; i < 5; i++){
                led1 = !led1;
                led2 = !led2;
                led3 = !led3;
                led4 = !led4;
                wait(1);
            }
            return -1;
        }
        //fprintf(fp, "The time is %s\n", ctime(&tnow));
        fprintf(fp, "time,,sensor1x,sensor1y,sensor1z,,sensor2x,sensor2y,sensor2z\n");
        /*for(int m = 0; m < 10; m++){        //ここで周回数を決める*/
        while(startsw == 0){
            if(ledv>0x10)ledv=1;  //ｋが0b00010000になったら0b00000001にする
            led1 = ledv & 0x01;
            led2 = ledv & 0x02;
            led3 = ledv & 0x04;
            led4 = ledv & 0x08;
            ledv=ledv<<1; //kの中を左に1つ移動(mbedのledを順番に点滅)
            
            for(int i = 0; i < 2; i++){     //平均を取るための合計を格納する変数を初期化
                for(int j = 0; j < 3; j++){
                    tempdata[i][j] = 0;
                }
            }
            
            wait(0.1-0.01*n);
            
            //以下データの平均をとってファイル出力
            for(int i = 0; i < n; i++){
                accelerometer1.getOutput(data[0]);
                accelerometer2.getOutput(data[1]);
                
                for(int j = 0; j < 2; j++){
                    for(int k = 0; k < 3; k++){
                        tempdata[j][k] += (int16_t)data[j][k];
                    }
                }
                wait_ms(10);
            }
            
            for(int i = 0; i < 2; i++){
                for(int j = 0; j < 3; j++){
                    pfdata[i][j] = tempdata[i][j] / n - kousei[i][j];
                }
            }
            
            fprintf(fp, "%f,,%f,%f,%f,,%f,%f,%f\n",timer.read(),pfdata[0][0],pfdata[0][1],pfdata[0][2],pfdata[1][0],pfdata[1][1],pfdata[1][2]);
        }
        timer.stop();
        Buzzer(5);
        fclose(fp);
    }
    
    ////////////////////////////////
    /*
    fp = fopen("/local/log.csv","w");
    for(int i = 0; i < 2000; i++){
        
        wait(0.5);
        
        if(ledv>0x10)ledv=1;  //ｋが0b00010000になったら0b00000001にする
        led1 = ledv & 0x01;
        led2 = ledv & 0x02;
        led3 = ledv & 0x04;
        led4 = ledv & 0x08;
        ledv=ledv<<1; //kの中を左に1つ移動
        
        accelerometer1.getOutput(data1);
        accelerometer2.getOutput(data2);
        
        fprintf(fp,"%i, %i, %i,,%i, %i, %i,,%f\n", (int16_t)data1[0], (int16_t)data1[1], (int16_t)data1[2], (int16_t)data2[0], (int16_t)data2[1], (int16_t)data2[2],timer.read());
        
    }
    fclose(fp);
    */
 
    /*while(1){
     
        wait(1);
        
        accelerometer1.getOutput(data1);
        accelerometer2.getOutput(data2);
         
        //13-bit, sign extended values.
        pc.printf("(%i, %i, %i),(%i, %i, %i)\n", (int16_t)data1[0], (int16_t)data1[1], (int16_t)data1[2], (int16_t)data2[0], (int16_t)data2[1], (int16_t)data2[2]);
    }*/
 
}


int SW(){        //スタートスイッチ用関数，押して離したらスタート
    int i = 0, j = 0;
    while(i < 3){       //チャタリング除去，15msにわたってスタートスイッチが押されていればbreak
        if(startsw == 1) i++;
        else i = 0;
        //DipLed();
        wait_ms(5);
    }
    while(j < 3){       //上に同じ，スタートスイッチが離されたことを検知
        if(startsw == 0) j++;
        else j = 0;
        //DipLed();
        wait_ms(5);
    }
    return 0;
}

int Buzzer(int buzvar){     //電子ブザーを鳴らす関数
    switch (buzvar){
        /**************エラーを知らせるbeep**************/
        case -3:        //error * - -
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1);
            buzzer = 1; wait(0.3); buzzer = 0; wait(0.3);
            buzzer = 1; wait(0.3); buzzer = 0; wait(0.3);
            break;
        case -2:        //error * - - -
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1);
            buzzer = 1; wait(0.3); buzzer = 0; wait(0.3);
            buzzer = 1; wait(0.3); buzzer = 0; wait(0.3);
            buzzer = 1; wait(0.3); buzzer = 0; wait(0.3);
            break;
        case -1:        //error * - - - -
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1);
            buzzer = 1; wait(0.3); buzzer = 0; wait(0.3);
            buzzer = 1; wait(0.3); buzzer = 0; wait(0.3);
            buzzer = 1; wait(0.3); buzzer = 0; wait(0.3);
            buzzer = 1; wait(0.3); buzzer = 0; wait(0.3);
            break;
        /**************エラーここまで**************/
        case 0:         //サウンドなし
            buzzer = 0;
            break;
        /**************状態を知らせるためのbeep**************/
        case 1:         // *(短)
            buzzer = 1; wait(0.1); buzzer = 0;
            break;
        case 2:         // * *
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.05);
            buzzer = 1; wait(0.1); buzzer = 0;
            break;
        case 3:         // -(長)
            buzzer = 1; wait(0.3); buzzer = 0;
            break;
        case 4:         // - -
            buzzer = 1; wait(0.3); buzzer = 0; wait(0.3);
            buzzer = 1; wait(0.3); buzzer = 0;
            break;
        case 5:         // ---
            buzzer = 1; wait(0.9); buzzer = 0;
            break;
        case 6:         // * * *  * * *  * * *  *
            for(int i = 0; i < 3; i++){
                for(int j = 0; j < 3; j++){
                    buzzer = 1; wait(0.1); buzzer = 0; wait(0.1);
                }
                wait(0.2);
            }
            buzzer = 1; wait(0.1); buzzer = 0;
            break;
        case 7:         // **-* ** -* ** *** **** "finish"
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            buzzer = 1; wait(0.3); buzzer = 0; wait(0.1); 
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            wait(0.2);
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            wait(0.2);
            buzzer = 1; wait(0.3); buzzer = 0; wait(0.1); 
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            wait(0.2);
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            wait(0.2);
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            wait(0.2);
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            buzzer = 1; wait(0.1); buzzer = 0;
            break;
        case 8:         // *-*** -*- --* "オワリ"
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1);
            buzzer = 1; wait(0.3); buzzer = 0; wait(0.1);
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            wait(0.2);
            buzzer = 1; wait(0.3); buzzer = 0; wait(0.1); 
            buzzer = 1; wait(0.1); buzzer = 0; wait(0.1); 
            buzzer = 1; wait(0.3); buzzer = 0; wait(0.1); 
            wait(0.2);
            buzzer = 1; wait(0.3); buzzer = 0; wait(0.1); 
            buzzer = 1; wait(0.3); buzzer = 0; wait(0.1); 
            buzzer = 1; wait(0.1); buzzer = 0;
            break;
        case 9:        //ケータイの着信音的な
            for(int i = 0; i < 20; i++){
                buzzer = 1; wait(0.03);
                buzzer = 0; wait(0.03);
            }
            break;
        case 10:        //9の短いバージョン
            for(int i = 0; i < 20; i++){
                buzzer = 1; wait(0.02);
                buzzer = 0; wait(0.02);
            }
            break;
        /**************状態を知らせるためのbeepここまで**************/
        default:        //no sound
            buzzer = 0;
            break;
    }
    return 0;
}
