#if !FEATURE_LWIP
    #error [NOT_SUPPORTED] LWIP not supported for this target
#endif

#include "mbed.h"
#include "EthernetInterface.h"
#include "TCPServer.h"
#include "TCPSocket.h"

int main()
{
    printf("Basic TCP server example\n");
    
    EthernetInterface eth;
    eth.connect();
    
    printf("The target IP address is '%s'\n", eth.get_ip_address());
    
    TCPServer srv;
    TCPSocket clt_sock;
    SocketAddress clt_addr;
    
    /* Open the server on ethernet stack */
    srv.open(&eth);
    
    /* Bind the HTTP port (TCP 80) to the server */
    srv.bind(eth.get_ip_address(), 80);
    
    /* Can handle 5 simultaneous connections */
    srv.listen(5);
    
    while (true) {
        srv.accept(&clt_sock, &clt_addr);
        printf("accept %s:%d\n", clt_addr.get_ip_address(), clt_addr.get_port());
        char rbuffer[64];
        int rcount = clt_sock.recv(rbuffer, sizeof rbuffer);
        printf("received data %s\n", rbuffer);
        clt_sock.send(rbuffer, rcount);
    }
}