#include "mbed.h"
#include "UMTSStickNetIf.h"
#include "HTTPClient.h"

UMTSStickNetIf stick; 
HTTPClient http;
  
int main() {

  printf("Setting up...\n");
  UMTSStickErr umtsStickErr = stick.setup();
  if(umtsStickErr)
  {
    printf("Error %d in setup.\n", umtsStickErr);
    return -1;
  }
  printf("Setup OK\r\n");
  
  PPPErr pppErr;
  printf("Connecting...\n");
  pppErr = stick.connect("prepaidnet", "mts", "064");
  if(pppErr)
  {
    printf("Error %d during connection.\n", pppErr);
    return -1;
  }

  HTTPText txt;
  
  HTTPResult r = http.get("http://tnt.etf.rs/~oe4irs/PMK_test.txt", &txt);
  if(r==HTTP_OK)
  {
    printf("Result :\"%s\"\n", txt.gets()); 
  }
  else
  {
    printf("Error %d\n", r);
  }
  
  printf("Disconnecting.\n");
   
  stick.disconnect();

  printf("Disconnected.\n");
  
  while(1)
  {
  
  }
  
  return 0;
  
}
