#include "mbed.h"
#include "EthernetNetIf.h"
#include "UDPSocket.h"

DigitalOut led4(LED4, "led4");

//EthernetNetIf eth ;
EthernetNetIf eth(
  IpAddr(192,168,1,110), //IP Address
  IpAddr(255,255,255,0), //Network Mask
  IpAddr(192,168,0,1), //Gateway
  IpAddr(192,168,0,1)  //DNS
);

UDPSocket udp;
int global_counter=0;
void onUDPSocketEvent(UDPSocketEvent e)
{
  switch(e)
  {
  case UDPSOCKET_READABLE: //The only event for now
    char buf[64] = {0};
    Host host;
    while( int len = udp.recvfrom( buf, 63, &host ) )
    {
      if( len <= 0 )
        break;
      printf("Received from %d.%d.%d.%d: %s and sent back to goup\r\n", host.getIp()[0], host.getIp()[1], host.getIp()[2], host.getIp()[3], buf);
    }
    udp.sendto( buf,strlen(buf)+1, &host );
    break;
  }
}

int main() {
  printf("Setting up...\n");
  EthernetErr ethErr = eth.setup(30000);
  if(ethErr)
  {
    printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  printf("Setup OK\n");
  
  Host multicast(IpAddr(224,0,0,0), 50000); //Join multicast group on port 50000
 
  udp.setOnEvent(&onUDPSocketEvent);  
  udp.bind(multicast);
  
  Timer tmr;
  tmr.start();
  while(true)
  {
    Net::poll();
    if(tmr.read() > 0.5)
    {
      led4=!led4; //Show that we are alive
      tmr.reset();
    }
  }  
}
