
#include "mbed.h"
#include "EthernetNetIf.h"
#include "TCPSocket.h"
// **********************************************************************
#define SERVER_ADR       IpAddr(192,168,1,110)   // server address
#define SERVER_PORT      12345   // server address
// **********************************************************************

DigitalOut led4(LED4, "led4");
int global_counter=0;

//EthernetNetIf eth;//using DHCP
EthernetNetIf eth(//manual configuration
  IpAddr(192,168,1,111), //IP Address
  IpAddr(255,255,255,0), //Network Mask
  IpAddr(192,168,1,1), //Gateway
  IpAddr(192,168,1,1)  //DNS
);

TCPSocket tcp;
Host server(SERVER_ADR,SERVER_PORT,"PMK server");
// **********************************************************************
struct{
    int connected;
    int writeable;
    int readable;
}flags;
// **********************************************************************
void onTCPSocketEvent(TCPSocketEvent e){    
    //printf("New TCPSocketEvent: %d\r\n",e);
    switch(e){
        case TCPSOCKET_CONNECTED:   flags.connected = 1;break;
        case TCPSOCKET_WRITEABLE:   flags.writeable = 1;break;
        case TCPSOCKET_READABLE:    flags.readable = 1;break;
        case TCPSOCKET_CONTIMEOUT:
        case TCPSOCKET_CONRST:
        case TCPSOCKET_CONABRT:
        case TCPSOCKET_ERROR:
        case TCPSOCKET_DISCONNECTED:
            tcp.close();
            flags.connected = 0;
        break;
    }
}
// **********************************************************************
int main(){    
    //button.mode(PullUp);    
    
    printf("Setting up...\n");
    EthernetErr ethErr = eth.setup();
    if(ethErr){
        printf("Ethernet Error %d\n", ethErr);
        return -1;
    }else{
        printf("mbed is online...\n");
    }
    
    flags.connected=0;
    flags.writeable=1;  
    flags.readable=0;  
    tcp.setOnEvent(&onTCPSocketEvent);
    
    printf("Conecting host...\n");
    TCPSocketErr err = tcp.connect(server);
    if(err){
        printf("Error connecting\n");
    }
    
    Timer tmr;
    tmr.start();
  
    while(true){
        Net::poll();
        
      
        if(flags.readable==1){
            char Buffer[100]={0};
            flags.readable=0;
            tcp.recv(Buffer,100);            
            printf("received from server: %s\r\n", Buffer);  
            printf("\r\n");        
        }// end if
        
        if(tmr.read() > 2) // sec
        {
          led4=!led4; //Show that we are alive
          tmr.reset();
           if(flags.writeable==1){
                flags.writeable=0;
                global_counter++;
                char Buffer[100]={0};
                sprintf(Buffer,"%d", global_counter);                
                tcp.send(Buffer,strlen(Buffer));                
                printf("data sent to server:%d\r\n", global_counter);
               
           };
        }
    
    }// end while(true)
}// end main
// **********************************************************************
