
#include "mbed.h"
#include "platform/mbed_thread.h"
#include <MQTTClientMbedOs.h>
#include "XNucleoIKS01A3.h"

// Blinking rate in milliseconds
#define BLINKING_RATE_MS                                                    500
// Initialise the digital pin LED1 as an output
DigitalOut led(LED1);

/* Instantiate the expansion board */
static XNucleoIKS01A3 *mems_expansion_board = XNucleoIKS01A3::instance(D14, D15, D4, D5, A3, D6, A4);
 
/* Retrieve the composing elements of the expansion board */
static STTS751Sensor *t_sensor = mems_expansion_board->t_sensor;
 
 
volatile int mems_event = 0;
uint32_t previous_tick = 0;
uint32_t current_tick = 0;
uint8_t high = 0, low = 0;
float temperature = 0.0f;
char buffer[32];
 
void INT_cb();
 
/* Helper function for printing floats & doubles */
static char *print_double(char *str, double v, int decimalDigits = 2)
{
    int i = 1;
    int intPart, fractPart;
    int len;
    char *ptr;
 
    /* prepare decimal digits multiplicator */
    for (; decimalDigits != 0; i *= 10, decimalDigits--);
 
    /* calculate integer & fractinal parts */
    intPart = (int)v;
    fractPart = (int)((v - (double)(int)v) * i);
 
    /* fill in integer part */
    sprintf(str, "%i.", intPart);
 
    /* prepare fill in of fractional part */
    len = strlen(str);
    ptr = &str[len];
 
    /* fill in leading fractional zeros */
    for (i /= 10; i > 1; i /= 10, ptr++) {
        if (fractPart >= i) {
            break;
        }
        *ptr = '0';
    }
 
    /* fill in (rest of) fractional part */
    sprintf(ptr, "%i", fractPart);
 
    return str;
}

InterruptIn button(USER_BUTTON);
int arrivedcount = 0;
TCPSocket socket;
MQTTClient client(&socket);
MQTT::Message message;
int button_pressed=0;

char* topic_pub = "PMK-client-temperature";
char* topic_sub = "PMK-client-topic_sub";

WiFiInterface *wifi;

const char *sec2str(nsapi_security_t sec)
{
    switch (sec) {
        case NSAPI_SECURITY_NONE:
            return "None";
        case NSAPI_SECURITY_WEP:
            return "WEP";
        case NSAPI_SECURITY_WPA:
            return "WPA";
        case NSAPI_SECURITY_WPA2:
            return "WPA2";
        case NSAPI_SECURITY_WPA_WPA2:
            return "WPA/WPA2";
        case NSAPI_SECURITY_UNKNOWN:
        default:
            return "Unknown";
    }
}

int scan_demo(WiFiInterface *wifi)
{
    WiFiAccessPoint *ap;
    printf("Scan:\n");
    int count = wifi->scan(NULL,0);
    if (count <= 0) {
        printf("scan() failed with return value: %d\n", count);
        return 0;
    }
    /* Limit number of network arbitrary to 15 */
    count = count < 15 ? count : 15;
    ap = new WiFiAccessPoint[count];
    count = wifi->scan(ap, count);
    if (count <= 0) {
        printf("scan() failed with return value: %d\n", count);
        return 0;
    }
    for (int i = 0; i < count; i++) {
        printf("Network: %s secured: %s BSSID: %hhX:%hhX:%hhX:%hhx:%hhx:%hhx RSSI: %hhd Ch: %hhd\n", ap[i].get_ssid(),
               sec2str(ap[i].get_security()), ap[i].get_bssid()[0], ap[i].get_bssid()[1], ap[i].get_bssid()[2],
               ap[i].get_bssid()[3], ap[i].get_bssid()[4], ap[i].get_bssid()[5], ap[i].get_rssi(), ap[i].get_channel());
    }
    printf("%d networks available.\n", count);
    delete[] ap;
    return count;
}

void messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    printf("Message arrived: qos %d, retained %d, dup %d, packetid %d\r\n", message.qos, message.retained, message.dup, message.id);
    printf("Payload %.*s\r\n", message.payloadlen, (char*)message.payload);
    ++arrivedcount;
}

void buttonFunction() {    
    button_pressed=1;   
}




int main()
{
    /* Attach callback to STTS751 INT */
    t_sensor->attach_int_irq(&INT_cb); 
    /* Enable STTS751 temperature sensor */
    t_sensor->enable();
    /* Set ODR to 4Hz */
    t_sensor->set_odr(4.0f);
    /* Set Low Temperature Threshold */
    t_sensor->set_low_temp_thr(22.0f);
    /* Set High Temperature Threshold */
    t_sensor->set_high_temp_thr(28.0f);
    /* Enable Event pin */
    t_sensor->set_event_pin(1);
    /* Get beginning status */
    t_sensor->get_temp_limit_status(NULL, NULL, NULL);
 
    button.rise(&buttonFunction);  // attach the address of the flip function to the rising edge
    
    const char* hostname = "broker.mqttdashboard.com";
    int port = 1883;    
    
    wifi = WiFiInterface::get_default_instance();
    if (!wifi) {
        printf("ERROR: No WiFiInterface found.\n");
        return -1;
    }

    int count = scan_demo(wifi);
    if (count == 0) {
        printf("No WIFI APs found - can't continue further.\n");
        return -1;
    }

    printf("\nConnecting to %s...\n", MBED_CONF_APP_WIFI_SSID);
    int ret = wifi->connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, NSAPI_SECURITY_WPA_WPA2);
    if (ret != 0) {
        printf("\nConnection error: %d\n", ret);
        return -1;
    }

    printf("Success\n\n");
    printf("MAC: %s\n", wifi->get_mac_address());
    printf("IP: %s\n", wifi->get_ip_address());
    printf("Netmask: %s\n", wifi->get_netmask());
    printf("Gateway: %s\n", wifi->get_gateway());
    printf("RSSI: %d\n\n", wifi->get_rssi());

    socket.open(wifi);
    socket.connect(hostname, port);
    
    int rc=0;
    
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    data.MQTTVersion = 3;
    data.clientID.cstring = "PMK-client";
    //data.username.cstring = "testuser";
    //data.password.cstring = "testpassword";
    if ((rc = client.connect(data)) != 0)
        printf("rc from MQTT connect is %d\r\n", rc);

    if ((rc = client.subscribe(topic_sub, MQTT::QOS2, messageArrived)) != 0)
        printf("rc from MQTT subscribe is %d\r\n", rc);

    while (true) {
        t_sensor->get_temperature(&temperature);
        printf("Temp[C]: %7s C\r\n", print_double(buffer, temperature));
        led = !led;
        thread_sleep_for(BLINKING_RATE_MS);
        if (button_pressed==1) {
            button_pressed=0;    
            printf("Publishing data\r\n");    
            // QoS 0
            char buf[100];
            sprintf(buf, "Temp[C]: %7s C\r\n", print_double(buffer, temperature));
            message.qos = MQTT::QOS0;
            message.retained = false;
            message.dup = false;
            message.payload = (void*)buf;
            message.payloadlen = strlen(buf)+1;
            client.publish(topic_pub, message);
        }
        printf("Yielding"); 
        client.yield(1000);
        printf(" -> Yielded\r\n"); 
        
    }
}

void INT_cb()
{
    mems_event = 1;
}