#include "mbed.h"
 
I2C tempsensor(PB_9, PB_8); //sda, sc1 
Serial pc(USBTX, USBRX); //tx, rx 
int addr = 0x94U;/** I2C Device Address 8 bit format **/
char config_t[3]; 
char temp_read[3];
int tempH, tempL;
float fTemp;

int main() { 
    pc.printf("Hello world!\n\r");
    config_t[0] = 0xFE; //send to pointer 'Manufacturer ID register' SEND_BYTE
    tempsensor.write(addr, config_t, 1);
    wait(0.1);
    tempsensor.read(addr, temp_read, 1); //read the one-byte data RECEIVE_BYTE
    pc.printf("Manufacturer ID=%d\n\r", temp_read[0]);
    wait(0.5);

    config_t[0] = 0x03; // WRITE_BYTE
    config_t[1] = 0x8C; // write 0x8C to configuration register 0x03
    tempsensor.write(addr, config_t, 2);
    wait(0.1); 

    config_t[0] = 0x04; // WRITE_BYTE
    config_t[1] = 0x04; // write 0x04 to configuration register 0x04
    tempsensor.write(addr, config_t, 2); 
    wait(0.1);

    while(1) { 
        wait(1);

        config_t[0] = 0x00; //set pointer reg to 'Temperature value high byte register' SEND_BYTE
        tempsensor.write(addr, config_t, 1);
        tempsensor.read(addr, temp_read, 1); //read tempH RECEIVE_BYTE
        tempH=temp_read[0];

        config_t[0] = 0x02; //set pointer reg to 'Temperature value low byte register' SEND_BYTE
        tempsensor.write(addr, config_t, 1);
        tempsensor.read(addr, temp_read, 1); //read tempL RECEIVE_BYTE
        tempL=temp_read[0];

        fTemp = ((tempH  * 256) + (tempL & 0xFC));// Convert the data to 12-bits
        fTemp=fTemp/256;

        pc.printf("Temp = %f degC\n\r", fTemp);
    } 
}
