#include "mbed.h"

#define IrThermo_Addr (0x5A<<1)
#define Tamb 0x06
#define Tobj 0x07

I2C i2c(D14, D15);
DigitalOut myled(LED1);
Serial console(SERIAL_TX, SERIAL_RX);

int temperature=0;
char data_read[2];
char data_write[1]= {Tobj};
char data_add[1]= {(0x2E)};

void changeAddress()
{
    //char newAddr[2]= {0x5E,0x00};
    char p1,p2;
    bool ch,ch2,ch3;
    
    //----read address to make sure it worked------------

    // send start bit
    i2c.start();
    // send universal address
    ch = i2c.write(0x00);
    // prints if sensor acknowledges
    if (!ch) console.printf("no ack\n");
    else console.printf("ack\n");
    // send EEPROM slave location address
    ch2 = i2c.write(0x2E);
    // send repeated start
    i2c.start();
    // send universal address 0x00 (seven bit) and use 1 as the eight bit -> 0x01
    i2c.write(0x01); // last bit 1 indicates read request
    // read LSB
    p1 = i2c.read(1);
    // read MSB
    p2 = i2c.read(1);
    // read PEC
    i2c.read(0);
    // release the bus
    i2c.stop();
    wait(0.1);
    // print hex
    console.printf("0x%x%x\nMSB 0x%x, LSB 0x%x\n", p2, p1, p2, p1);
    wait(10);
    
    
    // make sure i2c is inactive
    i2c.stop();
    wait(0.1);
    //send start bit
    i2c.start();
    // address the sensor using universal address 0x00 not its default 0x5A
    ch = i2c.write(0x00); // last bit 0 indicates write
    // prints if sensor acknowledges
    if (!ch) {
        console.printf("no ack\n");
    } else console.printf("ack 0x00\n");
    // write command
    // EEPROM address. Datasheet says 0x0E BUT!!! accessing EEPROM requires ading 0x20. Hence, 0x2E
    ch2 = i2c.write(0x2E);
    // prints if sensor acknowledges
    if (!ch2) console.printf("no ack address location\n");
    console.printf("ack 0x0E\n");
    // delete old address
    // LSB
    i2c.write(0x00);
    // MSB
    i2c.write(0x00);
    // use CRC-8 calculator to obtain PEC bit http://www.sunshine2k.de/coding/javascript/crc/crc_js.html
    // I send 2E0000 --> PEC 0x6F
    ch3 = i2c.write(0x6F);
    // prints if sensor acknowledges
    if(!ch3) console.printf("no PEC\n");
    else console.printf("PEC success\n");
    // release the bus
    i2c.stop();
    wait(1);

//-----set new address----------------

    // send start bit
    i2c.start();
    // send universal device address 0x00
    i2c.write(0x00);
    // prints if sensor acknowledges
    if (!ch) console.printf("no ack\n");
    else console.printf("ack\n");
    // send EEPROM location for slave address
    ch2 = i2c.write(0x2E);
    // prints if sensor acknowledges
    if (!ch2) console.printf("no ack slave address location\n");
    else console.printf("ack 2\n");
    //write new address anything between 0x0000 and 0x007F (default 0x5A, PEC 0xE1)
    // LSB
    i2c.write(0x04);
    // MSB
    i2c.write(0x00);
    // send PEC calculated from CRC-8
    // I send 2E0400 -> PEC 0x3B
    i2c.write(0x3B);
    // release the bus
    i2c.stop();
    wait(1);

//----read address to make sure it worked------------

    // send start bit
    i2c.start();
    // send universal address
    ch = i2c.write(0x00);
    // prints if sensor acknowledges
    if (!ch) console.printf("no ack\n");
    else console.printf("ack\n");
    // send EEPROM slave location address
    ch2 = i2c.write(0x2E);
    // send repeated start
    i2c.start();
    // send universal address 0x00 (seven bit) and use 1 as the eight bit -> 0x01
    i2c.write(0x01); // last bit 1 indicates read request
    // read LSB
    p1 = i2c.read(1);
    // read MSB
    p2 = i2c.read(1);
    // read PEC
    i2c.read(0);
    // release the bus
    i2c.stop();
    wait(0.1);
    // print hex
    console.printf("0x%x%x\nMSB 0x%x, LSB 0x%x\n", p2, p1, p2, p1);
    wait(10);
}

int main()
{
    console.printf("IrThermo Test\n");
    i2c.write(IrThermo_Addr, data_add, 1, 1);
    i2c.read(IrThermo_Addr, data_read, 2, 0);
    console.printf("Sensor Address: %x\n",data_read[0]);
    //changeAddress();
    
    while(1) {
        i2c.write(IrThermo_Addr, data_write, 1, 1);
        i2c.read(IrThermo_Addr, data_read, 2, 0);

        console.printf("Raw Data: %x %x\n",(data_read[0]), (data_read[1]));
        temperature = (int) ((int)data_read[1] << 8) | data_read[0];
        temperature = (temperature * 0.02 - 273.15);
        if (data_write[0]==Tamb) {
            console.printf("Ambient temperature= %d\n", temperature);
        } else {
            console.printf("Object temperature= %d\n", temperature);
        }
        myled = !myled;
        wait(1.0);
    }
    
}
