/*
 * DISCLAIMER: I hereby place this code in public domain.
 * This library should be considered not fit for production, and I present no warranties
 * that it is fit for any intent or purpose, use it at your own risk.
 * 
 * Nelson Oliveira
*/

#pragma once

#include "mbed.h"
#include "stdarg.h"

class SparkfunSerialLCD
{
private:
    //Direct access to the serial connection
    Serial _lcd;
public:
    /**
     * Constructor:
     * tx           TX pin (choose from list -> {9,13,28}) and an optional baud rate
     * baud         The baud rate for the LCD (optional, defaults to 9600)
     * clsError     Resets the LCD to defaults (must use immediatly after power on)
     */
    SparkfunSerialLCD(PinName tx, int baud = 9600, bool clrError = false);

    //basic functions
    void SendCmd(int target, int cmd);      //Send special commands (see tables below)
    void setCursor(int column, int row);    //Set writing cursor position
    void print(const char *msg);            //Sends message to screen
    void printf(const char *msg, ...);      //Sends formated message to screen
    void cls();                             //Clear screen
    void setSplash();                       //Sets the current text as the splash screen
    void setBaud(int baud);                 //Changes the LCD baud rate, defaults to 9600 in case of invalid value

    //Adjusts Backlight -> bright: 0 to 29 (darker to brighter)
    void Backlight(int bright);
    
    //Special bytes
    struct Cmd
    {
        enum Enum
        {
            Clear               = 0x01,
            CursorRight         = 0x14,
            CursorLeft          = 0x10,
            ScrollRight         = 0x1C,
            ScrollLeft          = 0x18,        
            DisplayOn           = 0x0C,
            DisplayOff          = 0x08,
            UnderlineCursorOn   = 0x0E,
            UnderlineCursorOff  = 0x0C,
            BlinkingCursorOn    = 0x0D,
            BlinkingCursorOff   = 0x0C,
            CursorPos           = 0x80,
            ResetUnit           = 0x11,
            SetSplash           = 0x0A,
            b2400               = 0x0B, //These lines stating with "b" are the baud rates
            b4800               = 0x0C,
            b9600               = 0x0D,
            b14400              = 0x0E,
            b19200              = 0x0F,
            b38400              = 0x10
        };
    };
    
    struct Target
    {
        enum Enum
        {
            LCD                 = 0xFE,
            Module              = 0x7C,
        };
    };
};
