/*
 * DISCLAIMER: I hereby place this code in public domain.
 * This library should be considered not fit for production, and I present no warranties
 * that it is fit for any intent or purpose, use it at your own risk.
 * 
 * Nelson Oliveira
*/

#include "mbed.h"
#include "SparkfunSerialLCD.h"

//Declares a SparkFun Serial LCD on mbed pin 13
SparkfunSerialLCD LCD(p13, 38400, true);

int main()
{
    LCD.Backlight(29);      //Ajdusts backlight to max
    LCD.setCursor(4,0);     //Initial cursor place
    LCD.print("SparkFun");
    LCD.setCursor(6,1);     //Cursor place on second line
    LCD.print("LCD");
    
    wait(2);                //Leaves message on screen for 2 seconds
    
    while (1)               //Eternal loop
    {
        LCD.cls();                      //Clear screen
        for (int i=0;i<255;i++)         //Simple repetition until 255
        {
            LCD.setCursor(0,0);         //Position cursor on the beginning of the first line
            LCD.printf("Loop: %d",i);   //Writes the current FOR count overwriting the previous text
        }
    }
}