#include "mbed.h"
#include "PCA9955.h"

//Create a PCA9955 object at the default address (ADDRESS_0)
PCA9955 driver(p28, p27);

int main()
{
    //Try to open the PCA9955
    if (driver.open()) {
        printf("Device detected!\n");

        //Reset the device
        //NOTE: This might reset other I2C devices as well!
        driver.reset();
        wait_ms(5);

        //Set all of the output states to PWM mode
        driver.allOutputStates(PCA9955::OUTPUT_PWM);

        //Set all of the output currents to maximum
        driver.allOutputCurrents(1.0);

        while (1) {
            //Generate a breathing effect on all of the outputs
            for (float i = 0.0; i < 360.0; i += 0.1)
                driver = 0.5 * (sinf(i * 3.14159265 / 180.0) + 1);
        }
    } else {
        error("Device not detected!\n");
    }
}
