/* NeatGUI Library
 * Copyright (c) 2013 Neil Thiessen
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "Font.h"

Font::Font(const char* table)
{
    m_FontTable = table;
    m_Color = 0xFFFFFFFF;
}

Font::Font(const char* table, unsigned int color)
{
    m_FontTable = table;
    m_Color = color;
}

BitmapImage Font::glyph(char c)
{
    while(1) {
        //Skip the height and numChars bytes
        const char *ptr = m_FontTable + 2;

        //Search for the character in the font table
        for(int i = 0; i < m_FontTable[0]; i++) {
            if (*ptr == c) {
                //Return the image
                return BitmapImage(m_FontTable + ptr[1] * 0xFF + ptr[2], m_Color);
            }
            ptr += 3;
        }

        //The character wasn't found, replace it with a space
        c = ' ';
    }
}

unsigned int Font::color()
{
    return m_Color;
}

void Font::color(unsigned int c)
{
    m_Color = c;
}

int Font::height()
{
    return m_FontTable[1];
}

int Font::measureString(const char* str)
{
    int i = 0;
    int slen = 0;

    //Find the length in pixels of the whole string
    while (str[i] != NULL) {
        slen += glyph(*str).width();
        i++;
    }

    return slen;
}

int Font::measureWord(const char* str)
{
    int i = 0;
    int wlen = 0;

    //Find the length in pixels of the next word (separated by whitespace)
    while ((str[i] > ' ') && (str[i] <= 0x7E)) {
        wlen += glyph(*str).width();
        i++;
    }

    return wlen;
}
