#include "mbed.h"
#include "MCP4922.h"

//Create an MCP4922 object
MCP4922 dac(p11, p13, p14);

int main()
{
    //Configure DAC A
    dac.referenceMode(MCP4922::DAC_A, MCP4922::REF_UNBUFFERED);
    dac.gainMode(MCP4922::DAC_A, MCP4922::GAIN_1X);
    dac.powerMode(MCP4922::DAC_A, MCP4922::POWER_NORMAL);

    while (1) {
        //Generate a sine wave on DAC A
        for (float i = 0.0; i < 360.0; i += 0.1)
            dac.write(MCP4922::DAC_A, 0.5 * (sinf(i * 3.14159265 / 180.0) + 1));
    }
}
