#include "mbed.h"
#include "MCP4725.h"

//Create an MCP4725 object at the default address (ADDRESS_0)
MCP4725 dac(p28, p27);

int main()
{
    //Try to open the MCP4725
    if (dac.open()) {
        printf("Device detected!\n");

        //Wake up the DAC
        //NOTE: This might wake up other I2C devices as well!
        dac.wakeup();

        while (1) {
            //Generate a sine wave on the DAC
            for (float i = 0.0; i < 360.0; i += 0.1)
                dac = 0.5 * (sinf(i * 3.14159265 / 180.0) + 1);
        }
    } else {
        error("Device not detected!\n");
    }
}
