#include "mbed.h"
#include "MAX17048.h"

MAX17048 gauge(p28, p27);

int main()
{
    //Try to open the MAX17048
    if (gauge.open()) {
        printf("Device detected!\n");

        //Load the default compensation value
        gauge.compensation(MAX17048::RCOMP0);

        while (1) {
            //Print the current state of charge
            printf("SOC = %f%%\n", (float)gauge);

            //Sleep for 0.5 seconds
            wait(0.5);
        }
    } else {
        error("Device not detected!\n");
    }
}
