#include "mbed.h"
#include "AES.h"

const char testVector1[16] = {
    0x6B, 0xC1, 0xBE, 0xE2, 0x2E, 0x40, 0x9F, 0x96,
    0xE9, 0x3D, 0x7E, 0x11, 0x73, 0x93, 0x17, 0x2A
};

const char testVector2[16] = {
    0xAE, 0x2D, 0x8A, 0x57, 0x1E, 0x03, 0xAC, 0x9C,
    0x9E, 0xB7, 0x6F, 0xAC, 0x45, 0xAF, 0x8E, 0x51
};

const char testVector3[16] = {
    0x30, 0xC8, 0x1C, 0x46, 0xA3, 0x5C, 0xE4, 0x11,
    0xE5, 0xFB, 0xC1, 0x19, 0x1A, 0x0A, 0x52, 0xEF
};

const char testVector4[16] = {
    0xF6, 0x9F, 0x24, 0x45, 0xDF, 0x4F, 0x9B, 0x17,
    0xAD, 0x2B, 0x41, 0x7B, 0xE6, 0x6C, 0x37, 0x10
};

bool testEncrypt128Ecb()
{
    const char key[16] = { 0x2B, 0x7E, 0x15, 0x16, 0x28, 0xAE, 0xD2, 0xA6, 0xAB, 0xF7, 0x15, 0x88, 0x09, 0xCF, 0x4F, 0x3C };
    const char expected1[16] = { 0x3A, 0xD7, 0x7B, 0xB4, 0x0D, 0x7A, 0x36, 0x60, 0xA8, 0x9E, 0xCA, 0xF3, 0x24, 0x66, 0xEF, 0x97 };
    const char expected2[16] = { 0xF5, 0xD3, 0xD5, 0x85, 0x03, 0xB9, 0x69, 0x9D, 0xE7, 0x85, 0x89, 0x5A, 0x96, 0xFD, 0xBA, 0xAF };
    const char expected3[16] = { 0x43, 0xB1, 0xCD, 0x7F, 0x59, 0x8E, 0xCE, 0x23, 0x88, 0x1B, 0x00, 0xE3, 0xED, 0x03, 0x06, 0x88 };
    const char expected4[16] = { 0x7B, 0x0C, 0x78, 0x5E, 0x27, 0xE8, 0xAD, 0x3F, 0x82, 0x23, 0x20, 0x71, 0x04, 0x72, 0x5D, 0xD4 };
    char out[16];

    //Encrypt the test vectors using AES 128-bit ECB mode
    AES aes(key, AES::KEY_128, AES::MODE_ECB);
    aes.encrypt(testVector1, out, 16);
    if (strncmp(out, expected1, 16) != 0)
        return false;
    aes.encrypt(testVector2, out, 16);
    if (strncmp(out, expected2, 16) != 0)
        return false;
    aes.encrypt(testVector3, out, 16);
    if (strncmp(out, expected3, 16) != 0)
        return false;
    aes.encrypt(testVector4, out, 16);
    if (strncmp(out, expected4, 16) != 0)
        return false;

    //Success!
    return true;
}

bool testDecrypt128Ecb()
{
    const char key[16] = { 0x2B, 0x7E, 0x15, 0x16, 0x28, 0xAE, 0xD2, 0xA6, 0xAB, 0xF7, 0x15, 0x88, 0x09, 0xCF, 0x4F, 0x3C };
    const char in1[16] = { 0x3A, 0xD7, 0x7B, 0xB4, 0x0D, 0x7A, 0x36, 0x60, 0xA8, 0x9E, 0xCA, 0xF3, 0x24, 0x66, 0xEF, 0x97 };
    const char in2[16] = { 0xF5, 0xD3, 0xD5, 0x85, 0x03, 0xB9, 0x69, 0x9D, 0xE7, 0x85, 0x89, 0x5A, 0x96, 0xFD, 0xBA, 0xAF };
    const char in3[16] = { 0x43, 0xB1, 0xCD, 0x7F, 0x59, 0x8E, 0xCE, 0x23, 0x88, 0x1B, 0x00, 0xE3, 0xED, 0x03, 0x06, 0x88 };
    const char in4[16] = { 0x7B, 0x0C, 0x78, 0x5E, 0x27, 0xE8, 0xAD, 0x3F, 0x82, 0x23, 0x20, 0x71, 0x04, 0x72, 0x5D, 0xD4 };
    char out[16];

    //Decrypt the test vectors using AES 128-bit ECB mode
    AES aes(key, AES::KEY_128, AES::MODE_ECB);
    aes.decrypt(in1, out, 16);
    if (strncmp(out, testVector1, 16) != 0)
        return false;
    aes.decrypt(in2, out, 16);
    if (strncmp(out, testVector2, 16) != 0)
        return false;
    aes.decrypt(in3, out, 16);
    if (strncmp(out, testVector3, 16) != 0)
        return false;
    aes.decrypt(in4, out, 16);
    if (strncmp(out, testVector4, 16) != 0)
        return false;

    //Success!
    return true;
}

bool testEncrypt192Ecb()
{
    const char key[24] = { 0x8E, 0x73, 0xB0, 0xF7, 0xDA, 0x0E, 0x64, 0x52, 0xC8, 0x10, 0xF3, 0x2B, 0x80, 0x90, 0x79, 0xE5, 0x62, 0xF8, 0xEA, 0xD2, 0x52, 0x2C, 0x6B, 0x7B };
    const char expected1[16] = { 0xBD, 0x33, 0x4F, 0x1D, 0x6E, 0x45, 0xF2, 0x5F, 0xF7, 0x12, 0xA2, 0x14, 0x57, 0x1F, 0xA5, 0xCC };
    const char expected2[16] = { 0x97, 0x41, 0x04, 0x84, 0x6D, 0x0A, 0xD3, 0xAD, 0x77, 0x34, 0xEC, 0xB3, 0xEC, 0xEE, 0x4E, 0xEF };
    const char expected3[16] = { 0xEF, 0x7A, 0xFD, 0x22, 0x70, 0xE2, 0xE6, 0x0A, 0xDC, 0xE0, 0xBA, 0x2F, 0xAC, 0xE6, 0x44, 0x4E };
    const char expected4[16] = { 0x9A, 0x4B, 0x41, 0xBA, 0x73, 0x8D, 0x6C, 0x72, 0xFB, 0x16, 0x69, 0x16, 0x03, 0xC1, 0x8E, 0x0E };
    char out[16];

    //Encrypt the test vectors using AES 192-bit ECB mode
    AES aes(key, AES::KEY_192);
    aes.encrypt(testVector1, out, 16);
    if (strncmp(out, expected1, 16) != 0)
        return false;
    aes.encrypt(testVector2, out, 16);
    if (strncmp(out, expected2, 16) != 0)
        return false;
    aes.encrypt(testVector3, out, 16);
    if (strncmp(out, expected3, 16) != 0)
        return false;
    aes.encrypt(testVector4, out, 16);
    if (strncmp(out, expected4, 16) != 0)
        return false;

    //Success!
    return true;
}

bool testDecrypt192Ecb()
{
    const char key[24] = { 0x8E, 0x73, 0xB0, 0xF7, 0xDA, 0x0E, 0x64, 0x52, 0xC8, 0x10, 0xF3, 0x2B, 0x80, 0x90, 0x79, 0xE5, 0x62, 0xF8, 0xEA, 0xD2, 0x52, 0x2C, 0x6B, 0x7B };
    const char in1[16] = { 0xBD, 0x33, 0x4F, 0x1D, 0x6E, 0x45, 0xF2, 0x5F, 0xF7, 0x12, 0xA2, 0x14, 0x57, 0x1F, 0xA5, 0xCC };
    const char in2[16] = { 0x97, 0x41, 0x04, 0x84, 0x6D, 0x0A, 0xD3, 0xAD, 0x77, 0x34, 0xEC, 0xB3, 0xEC, 0xEE, 0x4E, 0xEF };
    const char in3[16] = { 0xEF, 0x7A, 0xFD, 0x22, 0x70, 0xE2, 0xE6, 0x0A, 0xDC, 0xE0, 0xBA, 0x2F, 0xAC, 0xE6, 0x44, 0x4E };
    const char in4[16] = { 0x9A, 0x4B, 0x41, 0xBA, 0x73, 0x8D, 0x6C, 0x72, 0xFB, 0x16, 0x69, 0x16, 0x03, 0xC1, 0x8E, 0x0E };
    char out[16];

    //Decrypt the test vectors using AES 192-bit ECB mode
    AES aes(key, AES::KEY_192);
    aes.decrypt(in1, out, 16);
    if (strncmp(out, testVector1, 16) != 0)
        return false;
    aes.decrypt(in2, out, 16);
    if (strncmp(out, testVector2, 16) != 0)
        return false;
    aes.decrypt(in3, out, 16);
    if (strncmp(out, testVector3, 16) != 0)
        return false;
    aes.decrypt(in4, out, 16);
    if (strncmp(out, testVector4, 16) != 0)
        return false;

    //Success!
    return true;
}

bool testEncrypt256Ecb()
{
    const char key[32] = { 0x60, 0x3D, 0xEB, 0x10, 0x15, 0xCA, 0x71, 0xBE, 0x2B, 0x73, 0xAE, 0xF0, 0x85, 0x7D, 0x77, 0x81, 0x1F, 0x35, 0x2C, 0x07, 0x3B, 0x61, 0x08, 0xD7, 0x2D, 0x98, 0x10, 0xA3, 0x09, 0x14, 0xDF, 0xF4 };
    const char expected1[16] = { 0xF3, 0xEE, 0xD1, 0xBD, 0xB5, 0xD2, 0xA0, 0x3C, 0x06, 0x4B, 0x5A, 0x7E, 0x3D, 0xB1, 0x81, 0xF8 };
    const char expected2[16] = { 0x59, 0x1C, 0xCB, 0x10, 0xD4, 0x10, 0xED, 0x26, 0xDC, 0x5B, 0xA7, 0x4A, 0x31, 0x36, 0x28, 0x70 };
    const char expected3[16] = { 0xB6, 0xED, 0x21, 0xB9, 0x9C, 0xA6, 0xF4, 0xF9, 0xF1, 0x53, 0xE7, 0xB1, 0xBE, 0xAF, 0xED, 0x1D };
    const char expected4[16] = { 0x23, 0x30, 0x4B, 0x7A, 0x39, 0xF9, 0xF3, 0xFF, 0x06, 0x7D, 0x8D, 0x8F, 0x9E, 0x24, 0xEC, 0xC7 };
    char out[16];

    //Encrypt the test vectors using AES 256-bit ECB mode
    AES aes(key, AES::KEY_256);
    aes.encrypt(testVector1, out, 16);
    if (strncmp(out, expected1, 16) != 0)
        return false;
    aes.encrypt(testVector2, out, 16);
    if (strncmp(out, expected2, 16) != 0)
        return false;
    aes.encrypt(testVector3, out, 16);
    if (strncmp(out, expected3, 16) != 0)
        return false;
    aes.encrypt(testVector4, out, 16);
    if (strncmp(out, expected4, 16) != 0)
        return false;

    //Success!
    return true;
}

bool testDecrypt256Ecb()
{
    const char key[32] = { 0x60, 0x3D, 0xEB, 0x10, 0x15, 0xCA, 0x71, 0xBE, 0x2B, 0x73, 0xAE, 0xF0, 0x85, 0x7D, 0x77, 0x81, 0x1F, 0x35, 0x2C, 0x07, 0x3B, 0x61, 0x08, 0xD7, 0x2D, 0x98, 0x10, 0xA3, 0x09, 0x14, 0xDF, 0xF4 };
    const char in1[16] = { 0xF3, 0xEE, 0xD1, 0xBD, 0xB5, 0xD2, 0xA0, 0x3C, 0x06, 0x4B, 0x5A, 0x7E, 0x3D, 0xB1, 0x81, 0xF8 };
    const char in2[16] = { 0x59, 0x1C, 0xCB, 0x10, 0xD4, 0x10, 0xED, 0x26, 0xDC, 0x5B, 0xA7, 0x4A, 0x31, 0x36, 0x28, 0x70 };
    const char in3[16] = { 0xB6, 0xED, 0x21, 0xB9, 0x9C, 0xA6, 0xF4, 0xF9, 0xF1, 0x53, 0xE7, 0xB1, 0xBE, 0xAF, 0xED, 0x1D };
    const char in4[16] = { 0x23, 0x30, 0x4B, 0x7A, 0x39, 0xF9, 0xF3, 0xFF, 0x06, 0x7D, 0x8D, 0x8F, 0x9E, 0x24, 0xEC, 0xC7 };
    char out[16];

    //Decrypt the test vectors using AES 256-bit ECB mode
    AES aes(key, AES::KEY_256);
    aes.decrypt(in1, out, 16);
    if (strncmp(out, testVector1, 16) != 0)
        return false;
    aes.decrypt(in2, out, 16);
    if (strncmp(out, testVector2, 16) != 0)
        return false;
    aes.decrypt(in3, out, 16);
    if (strncmp(out, testVector3, 16) != 0)
        return false;
    aes.decrypt(in4, out, 16);
    if (strncmp(out, testVector4, 16) != 0)
        return false;

    //Success!
    return true;
}

bool testEncrypt128Cbc()
{
    const char key[16] = { 0x2B, 0x7E, 0x15, 0x16, 0x28, 0xAE, 0xD2, 0xA6, 0xAB, 0xF7, 0x15, 0x88, 0x09, 0xCF, 0x4F, 0x3C };
    const char iv[16] = { 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F };
    const char expected1[16] = { 0x76, 0x49, 0xAB, 0xAC, 0x81, 0x19, 0xB2, 0x46, 0xCE, 0xE9, 0x8E, 0x9B, 0x12, 0xE9, 0x19, 0x7D };
    const char expected2[16] = { 0x50, 0x86, 0xCB, 0x9B, 0x50, 0x72, 0x19, 0xEE, 0x95, 0xDB, 0x11, 0x3A, 0x91, 0x76, 0x78, 0xB2 };
    const char expected3[16] = { 0x73, 0xBE, 0xD6, 0xB8, 0xE3, 0xC1, 0x74, 0x3B, 0x71, 0x16, 0xE6, 0x9E, 0x22, 0x22, 0x95, 0x16 };
    const char expected4[16] = { 0x3F, 0xF1, 0xCA, 0xA1, 0x68, 0x1F, 0xAC, 0x09, 0x12, 0x0E, 0xCA, 0x30, 0x75, 0x86, 0xE1, 0xA7 };
    char out[16];

    //Encrypt the test vectors using AES 128-bit CBC mode
    AES aes(key, AES::KEY_128, AES::MODE_CBC, iv);
    aes.encrypt(testVector1, out, 16);
    if (strncmp(out, expected1, 16) != 0)
        return false;
    aes.encrypt(testVector2, out, 16);
    if (strncmp(out, expected2, 16) != 0)
        return false;
    aes.encrypt(testVector3, out, 16);
    if (strncmp(out, expected3, 16) != 0)
        return false;
    aes.encrypt(testVector4, out, 16);
    if (strncmp(out, expected4, 16) != 0)
        return false;

    //Success!
    return true;
}

bool testDecrypt128Cbc()
{
    const char key[16] = { 0x2B, 0x7E, 0x15, 0x16, 0x28, 0xAE, 0xD2, 0xA6, 0xAB, 0xF7, 0x15, 0x88, 0x09, 0xCF, 0x4F, 0x3C };
    const char iv[16] = { 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F };
    const char in1[16] = { 0x76, 0x49, 0xAB, 0xAC, 0x81, 0x19, 0xB2, 0x46, 0xCE, 0xE9, 0x8E, 0x9B, 0x12, 0xE9, 0x19, 0x7D };
    const char in2[16] = { 0x50, 0x86, 0xCB, 0x9B, 0x50, 0x72, 0x19, 0xEE, 0x95, 0xDB, 0x11, 0x3A, 0x91, 0x76, 0x78, 0xB2 };
    const char in3[16] = { 0x73, 0xBE, 0xD6, 0xB8, 0xE3, 0xC1, 0x74, 0x3B, 0x71, 0x16, 0xE6, 0x9E, 0x22, 0x22, 0x95, 0x16 };
    const char in4[16] = { 0x3F, 0xF1, 0xCA, 0xA1, 0x68, 0x1F, 0xAC, 0x09, 0x12, 0x0E, 0xCA, 0x30, 0x75, 0x86, 0xE1, 0xA7 };
    char out[16];

    //Decrypt the test vectors using AES 128-bit CBC mode
    AES aes(key, AES::KEY_128, AES::MODE_CBC, iv);
    aes.decrypt(in1, out, 16);
    if (strncmp(out, testVector1, 16) != 0)
        return false;
    aes.decrypt(in2, out, 16);
    if (strncmp(out, testVector2, 16) != 0)
        return false;
    aes.decrypt(in3, out, 16);
    if (strncmp(out, testVector3, 16) != 0)
        return false;
    aes.decrypt(in4, out, 16);
    if (strncmp(out, testVector4, 16) != 0)
        return false;

    //Success!
    return true;
}

bool testEncrypt192Cbc()
{
    const char key[24] = { 0x8E, 0x73, 0xB0, 0xF7, 0xDA, 0x0E, 0x64, 0x52, 0xC8, 0x10, 0xF3, 0x2B, 0x80, 0x90, 0x79, 0xE5, 0x62, 0xF8, 0xEA, 0xD2, 0x52, 0x2C, 0x6B, 0x7B };
    const char iv[16] = { 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F };
    const char expected1[16] = { 0x4F, 0x02, 0x1D, 0xB2, 0x43, 0xBC, 0x63, 0x3D, 0x71, 0x78, 0x18, 0x3A, 0x9F, 0xA0, 0x71, 0xE8 };
    const char expected2[16] = { 0xB4, 0xD9, 0xAD, 0xA9, 0xAD, 0x7D, 0xED, 0xF4, 0xE5, 0xE7, 0x38, 0x76, 0x3F, 0x69, 0x14, 0x5A };
    const char expected3[16] = { 0x57, 0x1B, 0x24, 0x20, 0x12, 0xFB, 0x7A, 0xE0, 0x7F, 0xA9, 0xBA, 0xAC, 0x3D, 0xF1, 0x02, 0xE0 };
    const char expected4[16] = { 0x08, 0xB0, 0xE2, 0x79, 0x88, 0x59, 0x88, 0x81, 0xD9, 0x20, 0xA9, 0xE6, 0x4F, 0x56, 0x15, 0xCD };
    char out[16];

    //Encrypt the test vectors using AES 192-bit CBC mode
    AES aes(key, AES::KEY_192, AES::MODE_CBC, iv);
    aes.encrypt(testVector1, out, 16);
    if (strncmp(out, expected1, 16) != 0)
        return false;
    aes.encrypt(testVector2, out, 16);
    if (strncmp(out, expected2, 16) != 0)
        return false;
    aes.encrypt(testVector3, out, 16);
    if (strncmp(out, expected3, 16) != 0)
        return false;
    aes.encrypt(testVector4, out, 16);
    if (strncmp(out, expected4, 16) != 0)
        return false;

    //Success!
    return true;
}

bool testDecrypt192Cbc()
{
    const char key[24] = { 0x8E, 0x73, 0xB0, 0xF7, 0xDA, 0x0E, 0x64, 0x52, 0xC8, 0x10, 0xF3, 0x2B, 0x80, 0x90, 0x79, 0xE5, 0x62, 0xF8, 0xEA, 0xD2, 0x52, 0x2C, 0x6B, 0x7B };
    const char iv[16] = { 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F };
    const char in1[16] = { 0x4F, 0x02, 0x1D, 0xB2, 0x43, 0xBC, 0x63, 0x3D, 0x71, 0x78, 0x18, 0x3A, 0x9F, 0xA0, 0x71, 0xE8 };
    const char in2[16] = { 0xB4, 0xD9, 0xAD, 0xA9, 0xAD, 0x7D, 0xED, 0xF4, 0xE5, 0xE7, 0x38, 0x76, 0x3F, 0x69, 0x14, 0x5A };
    const char in3[16] = { 0x57, 0x1B, 0x24, 0x20, 0x12, 0xFB, 0x7A, 0xE0, 0x7F, 0xA9, 0xBA, 0xAC, 0x3D, 0xF1, 0x02, 0xE0 };
    const char in4[16] = { 0x08, 0xB0, 0xE2, 0x79, 0x88, 0x59, 0x88, 0x81, 0xD9, 0x20, 0xA9, 0xE6, 0x4F, 0x56, 0x15, 0xCD };
    char out[16];

    //Decrypt the test vectors using AES 192-bit CBC mode
    AES aes(key, AES::KEY_192, AES::MODE_CBC, iv);
    aes.decrypt(in1, out, 16);
    if (strncmp(out, testVector1, 16) != 0)
        return false;
    aes.decrypt(in2, out, 16);
    if (strncmp(out, testVector2, 16) != 0)
        return false;
    aes.decrypt(in3, out, 16);
    if (strncmp(out, testVector3, 16) != 0)
        return false;
    aes.decrypt(in4, out, 16);
    if (strncmp(out, testVector4, 16) != 0)
        return false;

    //Success!
    return true;
}

bool testEncrypt256Cbc()
{
    const char key[32] = { 0x60, 0x3D, 0xEB, 0x10, 0x15, 0xCA, 0x71, 0xBE, 0x2B, 0x73, 0xAE, 0xF0, 0x85, 0x7D, 0x77, 0x81, 0x1F, 0x35, 0x2C, 0x07, 0x3B, 0x61, 0x08, 0xD7, 0x2D, 0x98, 0x10, 0xA3, 0x09, 0x14, 0xDF, 0xF4 };
    const char iv[16] = { 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F };
    const char expected1[16] = { 0xF5, 0x8C, 0x4C, 0x04, 0xD6, 0xE5, 0xF1, 0xBA, 0x77, 0x9E, 0xAB, 0xFB, 0x5F, 0x7B, 0xFB, 0xD6 };
    const char expected2[16] = { 0x9C, 0xFC, 0x4E, 0x96, 0x7E, 0xDB, 0x80, 0x8D, 0x67, 0x9F, 0x77, 0x7B, 0xC6, 0x70, 0x2C, 0x7D };
    const char expected3[16] = { 0x39, 0xF2, 0x33, 0x69, 0xA9, 0xD9, 0xBA, 0xCF, 0xA5, 0x30, 0xE2, 0x63, 0x04, 0x23, 0x14, 0x61 };
    const char expected4[16] = { 0xB2, 0xEB, 0x05, 0xE2, 0xC3, 0x9B, 0xE9, 0xFC, 0xDA, 0x6C, 0x19, 0x07, 0x8C, 0x6A, 0x9D, 0x1B };
    char out[16];

    //Encrypt the test vectors using AES 256-bit CBC mode
    AES aes(key, AES::KEY_256, AES::MODE_CBC, iv);
    aes.encrypt(testVector1, out, 16);
    if (strncmp(out, expected1, 16) != 0)
        return false;
    aes.encrypt(testVector2, out, 16);
    if (strncmp(out, expected2, 16) != 0)
        return false;
    aes.encrypt(testVector3, out, 16);
    if (strncmp(out, expected3, 16) != 0)
        return false;
    aes.encrypt(testVector4, out, 16);
    if (strncmp(out, expected4, 16) != 0)
        return false;

    //Success!
    return true;
}

bool testDecrypt256Cbc()
{
    const char key[32] = { 0x60, 0x3D, 0xEB, 0x10, 0x15, 0xCA, 0x71, 0xBE, 0x2B, 0x73, 0xAE, 0xF0, 0x85, 0x7D, 0x77, 0x81, 0x1F, 0x35, 0x2C, 0x07, 0x3B, 0x61, 0x08, 0xD7, 0x2D, 0x98, 0x10, 0xA3, 0x09, 0x14, 0xDF, 0xF4 };
    const char iv[16] = { 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F };
    const char in1[16] = { 0xF5, 0x8C, 0x4C, 0x04, 0xD6, 0xE5, 0xF1, 0xBA, 0x77, 0x9E, 0xAB, 0xFB, 0x5F, 0x7B, 0xFB, 0xD6 };
    const char in2[16] = { 0x9C, 0xFC, 0x4E, 0x96, 0x7E, 0xDB, 0x80, 0x8D, 0x67, 0x9F, 0x77, 0x7B, 0xC6, 0x70, 0x2C, 0x7D };
    const char in3[16] = { 0x39, 0xF2, 0x33, 0x69, 0xA9, 0xD9, 0xBA, 0xCF, 0xA5, 0x30, 0xE2, 0x63, 0x04, 0x23, 0x14, 0x61 };
    const char in4[16] = { 0xB2, 0xEB, 0x05, 0xE2, 0xC3, 0x9B, 0xE9, 0xFC, 0xDA, 0x6C, 0x19, 0x07, 0x8C, 0x6A, 0x9D, 0x1B };
    char out[16];

    //Decrypt the test vectors using AES 256-bit CBC mode
    AES aes(key, AES::KEY_256, AES::MODE_CBC, iv);
    aes.decrypt(in1, out, 16);
    if (strncmp(out, testVector1, 16) != 0)
        return false;
    aes.decrypt(in2, out, 16);
    if (strncmp(out, testVector2, 16) != 0)
        return false;
    aes.decrypt(in3, out, 16);
    if (strncmp(out, testVector3, 16) != 0)
        return false;
    aes.decrypt(in4, out, 16);
    if (strncmp(out, testVector4, 16) != 0)
        return false;

    //Success!
    return true;
}

int main()
{
    //Run all of the tests
    printf("Running AES tests...\n");
    printf("\tTesting AES 128-bit ECB mode encryption...");
    if (testEncrypt128Ecb())
        printf("passed!\n");
    else
        error("failed!\n");
    printf("\tTesting AES 128-bit ECB mode decryption...");
    if (testDecrypt128Ecb())
        printf("passed!\n");
    else
        error("failed!\n");
    printf("\tTesting AES 192-bit ECB mode encryption...");
    if (testEncrypt192Ecb())
        printf("passed!\n");
    else
        error("failed!\n");
    printf("\tTesting AES 192-bit ECB mode decryption...");
    if (testDecrypt192Ecb())
        printf("passed!\n");
    else
        error("failed!\n");
    printf("\tTesting AES 256-bit ECB mode encryption...");
    if (testEncrypt256Ecb())
        printf("passed!\n");
    else
        error("failed!\n");
    printf("\tTesting AES 256-bit ECB mode decryption...");
    if (testDecrypt256Ecb())
        printf("passed!\n");
    else
        error("failed!\n");
    printf("\tTesting AES 128-bit CBC mode encryption...");
    if (testEncrypt128Cbc())
        printf("passed!\n");
    else
        error("failed!\n");
    printf("\tTesting AES 128-bit CBC mode decryption...");
    if (testDecrypt128Cbc())
        printf("passed!\n");
    else
        error("failed!\n");
    printf("\tTesting AES 192-bit CBC mode encryption...");
    if (testEncrypt192Cbc())
        printf("passed!\n");
    else
        error("failed!\n");
    printf("\tTesting AES 192-bit CBC mode decryption...");
    if (testDecrypt192Cbc())
        printf("passed!\n");
    else
        error("failed!\n");
    printf("\tTesting AES 256-bit CBC mode encryption...");
    if (testEncrypt256Cbc())
        printf("passed!\n");
    else
        error("failed!\n");
    printf("\tTesting AES 256-bit CBC mode decryption...");
    if (testDecrypt256Cbc())
        printf("passed!\n");
    else
        error("failed!\n");
    printf("done!\n");
}
