#include "mbed.h"

// Use a simple PWM program to fade the 4 on-board LEDs
//  - Each LED fades on and off at different rates
//  - Uses on-board LEDs only, no external HW or PWM hardware required
//  - LED brightness is a factor of the duty cycle, i.e. how long the LED
//    is turned on during a given loop

// Setup the LED outputs and assign variables
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

int pwmloop = 0 ;         // loop counter from 0 to 255 and repeat
int led_value[4];        // array of led brightness
int led_change[4];        // array of led brightness change values

int i;                    // loop variable

int main() {
    led_value[0] = 3;    // init counter value
    led_value[1] = 5;
    led_value[2] = 7;
    led_value[3] = 9;

    led_change[0] = 5;    // set rate of led brightness change per led
    led_change[1] = 6;
    led_change[2] = 7;
    led_change[3] = 8;
            
    while(1) {
        
        for (pwmloop = 0; pwmloop < 256; pwmloop++) {
            // Drive LEDs, turned on when less than pwnloop, 0 = full off, 255 = full on
            if (led_value[0] < pwmloop) { led1 = 1; } else { led1 = 0; }
            if (led_value[1] < pwmloop) { led2 = 1; } else { led2 = 0; }
            if (led_value[2] < pwmloop) { led3 = 1; } else { led3 = 0; }
            if (led_value[3] < pwmloop) { led4 = 1; } else { led4 = 0; }

            // short wait - control over light fading speed, experiment with larger
            //              delays to show how the PWM is working.
            wait_us(20);
        }

        // Update LED brightness value at the end of the pwm loop
        for (i = 0; i<4; i++) {
            led_value[i] += led_change[i];
            
            // check range is withing 0 to 255, if not change direction
            if (led_value[i] > 255) {
                led_change[i] = -led_change[i];
            }
            if (led_value[i] < 0) {
                led_change[i] = -led_change[i];
            }            
        }
    }
}

