/*
Custom board descriptions
*/
#ifdef BOARD_CUST_H
#define BOARD_CUST_H
/* CustomMK20DX128
   Customer Visible interfaces - NH B022_Rev1

  //R-Bridge sensor
   DacOut   senseRaDrv (connected electrically ADC_DP0)
   ADC0_DP0 adcDiffInP0
   ADC0_DM0 adcDiffInP1 senseRbAdcP

   ptB1 adcIn adcTemperature1
   ptB2 adcIn adcTemperature2
   ptB0 adcIn adcAir   
   ptB16 out CustLedRed
   ptB17 out CustLedGrn
   ptB18 cap  capSens1
   ptB19 cap  capSens2
*/

/* Internal LiIon management interfaces
  ptA13 digOut enExtBat
  ptB3     adcIn adcVrechargeBat
  ADC0_DP3 adcIn adcRbatP
  ADC0_DM3 adcIn adcRbatM
  
  ptc0  adcIn adc10Vbat 
  ptC1 spare
  */
  /* External Power Management 
  ptC2 adcIn adcVextIn
  ptC8  adcIn adc10Vslr
*/

/* Serial North Bound Interfaces
 Shared Uart1Tx Halfduplex
  enSdiTx
  enSdiRx
  enWire1Tx
  enWire1Rx
*/

/* USB OTG 
   Vusb  (input to cmpUSB
   UsbDM
   UsbDP
   UsbOtg_Id
*/

/* External Two FLASH chips.
   ptc3 C4 C5 C6 C7
*/

/*Debug Serial Interafaces
either JTAG or openSDA
 ptA0 SWD_CLK
 pta1 Uart0RxDebug
 pta2 Uart0RxDebug
 pta3 SWD_DI0
*/


#endif // BOARD_CUST_H