#include "mbed.h"
 
class Flasher {
public:
    Flasher(PinName pin) : _pin(pin) {  // _pin(pin) means pass pin to the DigitalOut constructor
        _pin = 0;                                        // default the output to 0
    }
 
    void flash(int n) {
        for(int i=0; i<n*2; i++) {
            _pin = !_pin;
            wait(0.2);
        }
    }
 
private:
    DigitalOut _pin;
};
 
Flasher led(LED2);
Flasher led1(LED3);
 
int main() {
    led.flash(5);
    led.flash(2);
    led1.flash(7);
}
