//********************************************************************************************
//                                                                                           *
// AB&T Tecnologie Informatiche - Ivrea Italy                                                *
// http://www.bausano.net                                                                    *
// https://www.ethercat.org/en/products/791FFAA126AD43859920EA64384AD4FD.htm                 *
//                                                                                           *  
//********************************************************************************************    
//                                                                                           *
// This software is distributed as an example, in the hope that it could be useful,          *
// WITHOUT ANY WARRANTY, even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE       *
//                                                                                           *
//******************************************************************************************** 


// revision 2 - moved  "DigitalOut Led(LED1)"



//----- EasyCAT shield application basic example for mbed boards 170912 ----------------------
//----- Derived from the example project TestEasyCAT.ino for the AB&T EasyCAT Arduino shield

//----- Tested with the STM32 NUCLEO-F767ZI board --------------------------------------------



#include "mbed.h"   
#include "EasyCAT.h"                // EasyCAT library to interface the LAN9252
 

void Application (void); 

 
EasyCAT EASYCAT(DC_SYNC);                    // EasyCAT istantiation

                                    // The constructor allow us to choose the pin used for the EasyCAT SPI chip select 
                                    // Without any parameter pin 9 will be used 
                                                                      
                                    // for EasyCAT board REV_A we can choose between:
                                    // 8, 9, 10 
                                    //  
                                    // for EasyCAT board REV_B we can choose between:
                                    // 8, 9, 10, A5, 6, 7                                    

                                    // example:                                  
//EasyCAT EASYCAT(8);               // pin 8 will be used as SPI chip select


                                    // The chip select chosen by the firmware must match the setting on the board

                                    // On board REV_A the chip select is set soldering
                                    // a 0 ohm resistor in the appropriate position

                                    // On board REV_B the chip select is set
                                    // througt a bank of jumpers                                    



InterruptIn event(D2);           // This pin receive the SM interrupt 
                                 // generated by the LAN9252
 
 
void Campionatura(void); 



//---- global variables ---------------------------------------------------------------------------
unsigned long Millis = 0;
unsigned long PreviousCycle = 0;
int32_t data_test = 0;
int32_t j = 0;


//---- declarations for Arduino "millis()" emulation ----------------------- 

static Ticker uS_Tick;
static volatile uint32_t MillisVal = 0;

void InitMillis(void);    
void mS_Tick(void);
  
inline static uint32_t millis (void) 
{
    return MillisVal; 
};
 
      

//---------------------------------------------------------------------------------------------
 
int main(void)
{
          
  printf ("\nEasyCAT - Generic EtherCAT slave\n");      // print the banner

  InitMillis();                                         // init Arduino "millis()" emulation                

                                                        //---- initialize the EasyCAT board -----
                                                                  
  if (EASYCAT.Init() == true)                           // initialization
  {                                                     // succesfully completed
    printf ("initialized\n");                           //
  }                                                            
  
  else                                                  // initialization failed   
  {                                                     // the EasyCAT board was not recognized
    printf ("initialization failed\n");                 //     
                                                        // The most common reason is that the SPI 
                                                        // chip select choosen on the board doesn't 
                                                        // match the one choosen by the firmware
                                                             
    DigitalOut Led(LED1);                               //                                                                   
                                                                  
    while (1)                                           // stay in loop for ever
    {                                                   // with the led blinking
        Led = 1;                                        //    
        wait_ms(125);                                   //   
        Led = 0;                                        //
        wait_ms(125);                                   //
    }                                                   // 
  }


  event.fall(&Campionatura);    
   
 
  while (1)                                             
  {      
      // everything happens in interrupt
  }  
}

//---- interrupt service --------------------------------------------------------------------------------
 
                                                      // The EasyCAT task and the User 
                                                      // Application run in interrupt
                                                      //
                                                      // Take care that the EtherCAT task + User Application
                                                      // time is less that the master cycle time
                                                                  
  void Campionatura()                                 //                                                  
  {                                                   //
    EASYCAT.MainTask();                               // EtherCAT task
                                                      //  
    Application();  
    printf("%d \n", millis() - PreviousCycle);  
    PreviousCycle =  millis();                           // User application

  }

// User application

void Application (void)
{
    EASYCAT.BufferIn.Cust.centerXL = data_test;
    EASYCAT.BufferIn.Cust.centerYL = data_test;
    EASYCAT.BufferIn.Cust.forceL = data_test;
    EASYCAT.BufferIn.Cust.yawL = data_test;
    EASYCAT.BufferIn.Cust.pitchL = data_test;
    EASYCAT.BufferIn.Cust.rollL = data_test;
    EASYCAT.BufferIn.Cust.centerXR = data_test;
    EASYCAT.BufferIn.Cust.centerYR = data_test;
    EASYCAT.BufferIn.Cust.forceR = data_test;
    EASYCAT.BufferIn.Cust.yawR = data_test;
    EASYCAT.BufferIn.Cust.pitchR = data_test;
    EASYCAT.BufferIn.Cust.rollR = data_test;
    EASYCAT.BufferIn.Cust.yawH = data_test;
    EASYCAT.BufferIn.Cust.pitchH = data_test;
    EASYCAT.BufferIn.Cust.rollH = data_test;    
   
   data_test++; 
   
}


//--- functions for Arduino "millis()" emulation -------------------------------------


void InitMillis(void) 
{
  uS_Tick.attach (&mS_Tick, 0.001);        
}

void mS_Tick(void)
{
  MillisVal++;
}
