/**
 *  \brief CS294-84 demo \author Ben Zhang, Antonio Iannopollo
 *
 * This sampel code illustrates how to connect the mbed KL25Z platform to internet
 * thorugh the CC3000 wifi breakout board (http://www.adafruit.com/product/1469).
 * Connections between the KL25Z and the CC3000 are made according to the
 * guide at https://learn.adafruit.com/adafruit-cc3000-wifi -- KL25Z and arduino
 * UNO are pin to pin compatible --
 *
 * This application uses the following libraries:
 * - cc3000_hostdriver_mbedsocket
 *   (http://developer.mbed.org/users/Kojto/code/cc3000_hostdriver_mbedsocket/)
 * - HTTPClient (http://developer.mbed.org/users/donatien/code/HTTPClient/)
 */

#include "mbed.h"
#include "cc3000.h"
#include "HTTPClient.h"

// KL25Z wifi connection
// we need to define connection pins for:
// - IRQ      => (pin D3)
// - Enable   => (pin D5)
// - SPI CS   => (pin D10)
// - SPI MOSI => (pin D11)
// - SPI MISO => (pin D12)
// - SPI CLK  => (pin D13)
// plus wifi network SSID, password, security level and smart-configuration flag.
mbed_cc3000::cc3000 wifi(D3, D5, D10, SPI(D11, D12, D13),
                         "SSID", "PASSWORD", WPA2, false);

// create an http instance
HTTPClient http;

// str is used to hold the response data
char str[512];
char url[80];

// setup the serial connection, and LEDs
Serial pc(USBTX, USBRX);
DigitalOut led_red(LED_RED);
DigitalOut led_green(LED_GREEN);

int main() {
  // by default, it's red
  led_red = 0;
  led_green = 1;

  // print message to indicate the program has started
  pc.printf("CC3000 Sample Program\r\n");
  wifi.init();

  while(1) {
    // continuosly check connection status
    if(wifi.is_connected() == false) {
      // try to connect
      if (wifi.connect() == -1) {
        pc.printf("Failed to connect."
                  "Please verify connection details and try again.\r\n");
      } else {
        pc.printf("IP address: %s \r\n", wifi.getIPAddress());

        //once connected, turn green LED on and red LED off
        led_red = 1;
        led_green = 0;
      }
    } else {
      // get input url and then return the value
      pc.printf("> ");
      pc.scanf("%s", url);

      int ret = http.get(url, str, 128);
      if (!ret) {
        pc.printf("Requested %s\r\n", url);
        pc.printf("Page fetched successfully - read %d characters\r\n",
                  strlen(str));
        pc.printf("Result: %s\r\n", str);
      } else {
        pc.printf("Error - ret = %d - HTTP return code = %d\r\n",
                  ret,
                  http.getHTTPResponseCode());
      }
    }
  }
}
