#include <mbed.h>
#include <string>
#include <list>
#include <vector>

#include <mpr121.h> // Touchpad
#include "SDFileSystem.h" // SD Card
#include "uLCD_4DGL.h" // uLCD


//  Global Variables
int wpm;            // Words Per Minute
int wpmChange;
int play;           // 1 -> Play  ||  0-> Pause
int pause;          // Slight pause
int reset;          // Reset Flag
int menuX;          // Menu cursor
int menuY;
int numFiles;       // Number of files in dir
int fileChoose;     // File choose flag




// Setup the Serial to the PC for debugging
Serial pc(USBTX, USBRX);


// **********   LCD    **********
uLCD_4DGL uLCD(p28, p27, p29); // create a global lcd object


// ********** Touchpad **********

// Create the interrupt receiver object on pin 26
InterruptIn interrupt(p26);

// Setup the i2c bus on pins 9 and 10
I2C i2c(p9, p10);

// Setup the Mpr121:
// constructor(i2c object, i2c address of the mpr121)
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);

void fallInterrupt()
{
    double value = mpr121.read(0x00);
    value +=mpr121.read(0x01)<<8;

    if(value!=0) {
        int val = log(value)/log(2.0);
        // uLCD.printf("%i\n",val);

        switch(val) {
            case 0: // Repeat
                reset = 1;
                break;
            case 2: // Decrease speed
                if(wpm>100) {
                    wpm -=100;
                    wpmChange = 1;
                }

                break;
            case 5: // Down

                if(menuY<numFiles+1)
                    menuY++;
                break;
            case 6: // Play/Pause
                play = (play==0) ? 1 :0;
                break;
            case 7: // Up

                if(menuY>2)
                    menuY--;
                break;
            case 8: // Enter
                fileChoose = 1;
                break;
            case 10: // Increase Speed

                if(wpm<500) {
                    wpm +=100;
                    wpmChange = 1;
                }

                break;

            default:
                break;
        }


    }

}

// ********** SD Card **********
SDFileSystem sd(p5, p6, p7, p8, "sd");

//read all directory and file names in current directory into filename vector
vector<string> filenames;
void read_file_names(char *dir)
{
    DIR *dp;
    struct dirent *dirp;
    dp = opendir(dir);
    while((dirp = readdir(dp)) != NULL) {
        filenames.push_back(string(dirp->d_name));
    }
    closedir(dp);
}


// Function to print the words per minute on uLCD
void printWPM()
{
    uLCD.text_width(1);
    uLCD.text_height(2);
    uLCD.locate(0,7);
    uLCD.color(WHITE);
    uLCD.printf("%i wpm",wpm);
}

int main()
{

    // Initializations
    wpm = 300;
    play = 1;
    wpmChange = 0;
    reset = 0;
    pause = 0;
    menuX = 15;
    menuY = 2;
    numFiles = 0;
    fileChoose = 0;

    // Check for input from the touchpad
    interrupt.mode(PullUp);
    interrupt.fall(&fallInterrupt);


    // Debug in console
    pc.printf("\nHello World\n\r");

    read_file_names("/sd/mydir");
    uLCD.color(WHITE);
    uLCD.printf("/sd/mydir\n\n");
    uLCD.color(GREEN);

    // Display file names in the menu
    for(vector<string>::iterator it=filenames.begin(); it < filenames.end(); it++) {
        uLCD.printf(" - %s\n\r",(*it).c_str());
        numFiles++;
    }

    // Choose the file to read
    while(fileChoose == 0) {
        uLCD.filled_rectangle(107,0,128,128,BLACK);
        interrupt.fall(&fallInterrupt);
        uLCD.locate(menuX,menuY);
        uLCD.color(BLUE);
        uLCD.printf("<--");
    }

    char fn[30] = "";
    int num = 0;
    for(vector<string>::iterator it=filenames.begin(); it < filenames.end(); it++) {
        if(num==(menuY-2))
            strcpy(fn,(*it).c_str());
        num++;
    }

    uLCD.cls();


    pc.printf("%s",fn);

    uLCD.text_width(3);
    uLCD.text_height(3);
    uLCD.locate(0,1);
    uLCD.color(WHITE);
    uLCD.printf("%s",fn);
    wait(2);

    /*

    // Write to file if needed
     pc.printf("Start writing\n\r");
     mkdir("/sd/mydir", 0777);


     FILE *fp = fopen("/sd/mydir/sdtest", "w");
     if(fp == NULL) {
         error("Could not open file for write\n");
     }

    fprintf(fp, "This is a demo for our project uLCD Text Reader. You can read at speeds between 100 words per minute to 500 words per minute. ");
    fprintf(fp, "You can use the MPR121 12-key touch pad to play, pause and reset the text stream. The mbed reads the text file from the microSD card. ");
    fprintf(fp, "Give it a try: ");
    fprintf(fp, "3! 2! 1! Go Jackets! ");
    fprintf(fp, "I'm a Ramblin' Wreck from Georgia Tech, and a hell of an engineer. ");
    fprintf(fp, "A helluva, helluva, Helluva, helluva, hell of an engineer. ");
    fprintf(fp, "Like all the jolly good fellows, I drink my whiskey clear. ");
    fprintf(fp, "I'm a Ramblin' Wreck from Georgia Tech and a hell of an engineer. ");

    fprintf(fp, "Oh! If I had a daughter, sir, I'd dress her in White and Gold, ");
    fprintf(fp, "And put her on the campus to cheer the brave and bold. ");
    fprintf(fp, "But if I had a son, sir, I'll tell you what he'd do— ");
    fprintf(fp, "He would yell, 'To hell with Georgia!' like his daddy used to do. ");

    fprintf(fp, "Oh, I wish I had a barrel of rum and sugar three thousand pounds, ");
    fprintf(fp, "A college bell to put it in and a clapper to stir it round. ");
    fprintf(fp, "I'd drink to all the good fellows who come from far and near. ");
    fprintf(fp, "I'm a ramblin', gamblin', hell of an engineer! ");


    fclose(fp);
    */

    // Open the selected file in read mode
    char path[] = "/sd/mydir/";
    strcat(path,fn);
    pc.printf("Start reading\n\r %s",path);

    FILE *fp1 = fopen(path, "r");
    if(fp1 == NULL) {
        error("Could not open file for read\n");
    }

    // Setup the display on uLCD
    uLCD.cls();
    uLCD.line(0, 82, 127, 82, WHITE);
    uLCD.line(0, 58, 127, 58, WHITE);
    uLCD.line(62, 54, 62, 62, RED);
    uLCD.line(63, 54, 63, 62, RED);
    uLCD.line(62, 80, 62, 88, RED);
    uLCD.line(63, 80, 63, 88, RED);
    printWPM();


    char oneword[9]; // The current temp word buffer
    char disp[9];    // The current word
    int len;        // length of the current word


    while(1) {

        // Read till the end of the file
        while(!feof(fp1)) {

            // Reser Mode
            if(reset == 1) {
                fclose(fp1);
                char path[] = "/sd/mydir/";
                strcat(path,fn);
                FILE *fp1 = fopen(path, "r");

                if(fp1 == NULL) {
                    pc.printf("Start reading\n\r %s",path);
                    error("Could not open file for read\n");
                }
                reset = 0;
                uLCD.text_width(3);
                uLCD.text_height(3);
                uLCD.locate(2,0);
                uLCD.color(RED);
                uLCD.printf("<<");
                wait(0.5);
                uLCD.filled_rectangle(0,0,128,40,BLACK);
            }

            // Pause
            while(play == 0) {

                uLCD.text_width(3);
                uLCD.text_height(3);
                uLCD.locate(2,0);
                uLCD.color(RED);
                uLCD.printf("||");
                interrupt.fall(&fallInterrupt);
                printWPM();
                if(reset == 1) {
                    fclose(fp1);
                    char path[] = "/sd/mydir/";
                    strcat(path,fn);
                    FILE *fp1 = fopen(path, "r");
                    if(fp1 == NULL) {
                        pc.printf("Start reading\n\r %s",path);
                        error("321Could not open file for read\n");
                    }
                    reset = 0;
                    play = 1;
                    uLCD.text_width(3);
                    uLCD.text_height(3);
                    uLCD.locate(2,0);
                    uLCD.color(RED);
                    uLCD.printf("<<");
                    wait(0.5);
                    uLCD.filled_rectangle(0,0,128,40,BLACK);


                }
                if(play==1) {
                    uLCD.text_width(3);
                    uLCD.text_height(3);
                    uLCD.locate(2,0);
                    uLCD.color(RED);
                    uLCD.printf("> ");
                    wait(0.5);
                    uLCD.filled_rectangle(0,0,128,40,BLACK);
                }
            }

            // Change in words per minute
            if(wpmChange == 1) {
                printWPM();
                wpmChange = 0;
            }
            uLCD.text_width(2);
            uLCD.text_height(2);
            uLCD.color(WHITE);
            uLCD.locate(0,4);

            // Diplay the current word

            fscanf(fp1, "%s",oneword);
            len = strlen(oneword);
            //pc.printf("%i",len);

            for(int i = 0; i< (9-len)/2 ; i++) {
                disp[i] = ' ';
            }
            for(int j = 0 , i = (9-len)/2  ; j< len ; i++) {
                if(oneword[j] == '.' || oneword[j] == '!' || oneword[j] == ',') {
                    pause = 1;
                }
                disp[i] = oneword[j++];
            }

            for(int i = (9-len)/2   +  len ; i<9; i++) {
                disp[i] = ' ';
            }

            for(int i=0; i<9; i++) {
                if(i==4)
                    uLCD.color(RED);
                else
                    uLCD.color(WHITE);
                uLCD.printf("%c", disp[i]);
            }

            // Handle wait time for wpm speed and processing time
            // Offer slight pause in the sentence to enhance reading
            float temp = (pause ==1) ? (60.0/(wpm-(0.5*wpm))) : (60.0/wpm);
            wait(temp - 0.1);
            pause = 0;




        }
        fclose(fp1);
        interrupt.fall(&fallInterrupt);
    }


}