
//----------------------------------------
// RFID IRQ = pin8 -> Non utilisé. Laissez ouvert
// RFID MISO = pin6 -> Nucleo SPI_MISO = PA_6 = D12
// RFID MOSI = pin5 -> Nucleo SPI_MOSI = PA_7 = D11
// RFID SCK = pin7 -> Nucleo SPI_SCK = PA_5 = D13
// RFID SDA = pin18 -> Nucleo SPI_CS = PB_6 = D10
// RFID RST = pin16 -> Nucleo = PA_9 = D8
                             
                              
#include "mbed.h"
#include "MFRC522.h"

// Nucleo Pin pour réinitialisation MFRC522 (D8 autre D si utiliser)

#define SPI_MOSI    p5
#define SPI_MISO    p6
#define SPI_SCK    p7
#define SPI_CS      p18
#define MF_RESET    p16


DigitalOut LedGreen(LED1);

//Connexion série au PC pour la sortie
Serial pc(USBTX, USBRX);

MFRC522    RfChip   (SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, MF_RESET);

int main(void) {
  pc.printf("starting...\n");

  // Init. RC522 Chip
  RfChip.PCD_Init();

  while (true) {
    LedGreen = 1;
    // Look for new cards
    if ( ! RfChip.PICC_IsNewCardPresent())
    {
      
    wait_ms(500);
      continue;
    }
    
    // Select one of the cards
    if ( ! RfChip.PICC_ReadCardSerial())
    {
        pc.printf("Rien");
      wait_ms(500);
      continue;
    }

    LedGreen = 0;

    // Print ID de la Card 
    pc.printf("Card ID: ");
    for (uint8_t i = 0; i < RfChip.uid.size; i++)
    {
      pc.printf(" %X02", RfChip.uid.uidByte[i]);
    }
    pc.printf("\n\r");

    // Print type de Card
    uint8_t piccType = RfChip.PICC_GetType(RfChip.uid.sak);
    pc.printf("PICC Type: %s \n\r", RfChip.PICC_GetTypeName(piccType));
    wait_ms(1000);
  }
}