#include "mbed.h" 
#include "MFRC522.h" 
// FRDM-K64F (Freescale) Pin for MFRC522 reset 
#define MF_RESET    PTD0 
#define SERIAL_1

DigitalOut LedGreen(LED2); 

//Serial connection to PC for output 
Serial pc(PTC17, PTC16); // serial comm on the FRDM board

//wireless bluetooth connection to Android Device for output
Serial blue(PTC15, PTC14);   

 
//MFRC522    RfChip   (SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, MF_RESET); 
MFRC522    RfChip   (PTD2, PTD3, PTD1, PTE25, PTD0); 
 
int main(void) { 
   
   blue.baud(9600);
   pc.baud(9600);
   printf("Welcome to RFID Tag Reader Using FRDM K64F...\n\r");
   blue.printf("Welcome to RFID Tag Reader Uing FRDM K64F...\n\r");
   printf("Bluetooth Enable\r\n");
   blue.printf("Bluetooth Enable\r\n");
   RfChip.PCD_Init(); 
 
   while (true) { 
     LedGreen = 1; 
 
     // Look for new cards 
     if ( ! RfChip.PICC_IsNewCardPresent()) 
     { 
       wait_ms(200); 
       continue; 
     } 
 
     // Select one of the cards 
     if ( ! RfChip.PICC_ReadCardSerial()) 
     { 
       wait_ms(200); 
       continue; 
     } 
      LedGreen = 0;
      int a=0; 
 
     // Print Card UID 
     printf("Card UID:"); 
     blue.printf("Card UID:");
     for (uint8_t i = 0; i < RfChip.uid.size; i++) 
     { 
      printf(" %X02 ", RfChip.uid.uidByte[i]);
      blue.printf(" %X02 ", RfChip.uid.uidByte[i]);
      a = RfChip.uid.uidByte[0];
     }  
     
     //Print Card Type
    if(a==117 || a==177)  
    { 
         printf("\r\nWhite Card");
         blue.printf("\r\nWhite Card");
     }
     else if(a==226 || a==20)
     {
         printf("\r\nBlue Keychain");
         blue.printf("\r\nBlue Keychain");
     }
     else
     {
         printf("\r\nUnrecognized");
         blue.printf("\r\nUnrecognized");
     }     
     printf("\n\r"); 
     blue.printf("\n\r"); 
     
     // Print RFID Card type 
     uint8_t piccType = RfChip.PICC_GetType(RfChip.uid.sak); 
     printf("PICC Type: %s \n\n\r\r", RfChip.PICC_GetTypeName(piccType));
     blue.printf("PICC Type: %s \n\n\r\r", RfChip.PICC_GetTypeName(piccType));
     
     wait_ms(200); 
     
   } 
 } 
 
