/*
*******************************************************************************************
* Motion activated temprature and humidity measuring  using humidity and PIR sensor.
* while measuring it will notify the sourunding by blikinking LED and making buzzer sound. 
*  The measuured data is sent to  Thingsspeak cloud server
*--PIR Motion Sensor Alarm + ESP8622 WiFi Module + FRDM-k64f
* --PIR sensor can detect change on its surrounding by measuring the change of infra red
* --Then will send high=1 to the FRDM-k64f to flash the LED, Run the Buzzer,
* --Send information through UART serial Port to Tera Term and display how many motion been
*---detected,also will send information to Thingspeak IoT website using WiFi connection 
********************************************************************************************
*/

#include "mbed.h"
#include "DHT.h"
#include "ESP8266.h"
#include "MFRC522.h" 


#define APIKEY 7PPRUQANXEJ0UURH
#define IP "184.106.153.149" // thingspeak.com IP Address
DHT sensor(D4, DHT11);

void printer_contractor( );
float timprature_humidity_contractor();
DigitalOut outside_green_led(D13);
Serial blue(PTC15, PTC14);
DigitalOut ledgreen(LED_GREEN);
DigitalOut ledred(LED_RED);
Serial pc(USBTX,USBRX);
DigitalOut Buzzer(D10); // output
PwmOut LED(D13); // flashing the led
DigitalIn inputPin(D2); // pir senor input
DigitalOut greenled(LED2);
ESP8266 wifi(PTC17, PTC16, 9600); // baud rate for wifi


char snd[255],rcv[1000];
int myclock=0; //( myclock=0; myclock < max_clock; myclock ++ )
int max_clock=20;
int val = 0; // value to holed the high/low info from pir from pin D2
int cnt = 0; // counter for motion
//String thingtweetAPIKey = "TTEVLP931ODJ5GMT";

/************ WiFi INTIALIZATION *********/
void printer_contractor( );
float timprature_humidity_contractor();
void wifi_initialize();
void wifi_send();

int main() 
{  
    blue.baud(9600);
   
      while(1)
            
          {   // calling functions for diffrent task
          
              printer_contractor(); // calling the function that print message for the process.
              
              wifi_initialize(); //
              wifi_send();       //
              
             
              
          }
          
          
        
   
}


void printer_contractor()
{       outside_green_led = 1; // toggle pin
        ledred= 1; // toggle led
        LED=1;
        Buzzer=1;
        printf(" Motion activated  TEMPRATURE and HUMIDITY measurement device: \n");  
        blue.printf(" Motion activated  TEMPRATURE and HUMIDITY measurement device: \n");
        printf("\t :Sending IMPOTRTANT information to AGENT- CLOUD \n ");
        blue.printf("\t :Sending IMPOTRTANT information to AGENT- CLOUD \n ");
        printf("\t :tmprature & humidity  testing begin wait... \n ");
        blue.printf("\t :tmprature & humidity  testing begin wait... \n ");
        wait(3);
}
   



 void wifi_initialize()

 {
    
pc.baud(9600);   
pc.printf("SET mode to AP\r\n");
blue.printf("SET mode to AP\r\n");
wifi.SetMode(1);    // set ESP mode to 1
wifi.RcvReply(rcv, 1000);    //receive a response from ESP
pc.printf("%s",rcv);    //Print the response onscreen
blue.printf("%s",rcv);
pc.printf("Conneting to AP\r\n");
blue.printf("Conneting to AP\r\n");
wifi.Join("Network", "Password");     // Your wifi username & Password 
wifi.RcvReply(rcv, 1000);    //receive a response from ESP
pc.printf("%s", rcv);    //Print the response onscreen
blue.printf("%s",rcv);
wait(5);     //waits for response from ESP
pc.printf("Getting IP\r\n");    //get IP addresss from the connected AP
blue.printf("Getting IP\r\n"); 
wifi.GetIP(rcv);    //receive an IP address from the AP
pc.printf("%s", rcv); 
blue.printf("%s", rcv); 
wait(5); // Delay 5 sec to give the pir time to get snapshut of the surrounding
pc.printf(" WAIT:Initializing WiFi\r\n");
blue.printf(" WAIT:Initializing WiFi\r\n");
    while (1)
      {
       
   val = inputPin.read();
   
   if (val==0) {   
    cnt++;
    pc.printf(" The Sensor is ON:  %i Motion Detected NOW \r\n\n",cnt);
    blue.printf(" The Sensor is ON:  %i Motion Detected NOW \r\n\n",cnt);
    
    printf(" NOW lets messure  Temprature and humudity of the enviroment:\n\n\n\n");
    blue.printf(" NOW lets messure  Temprature and humudity of the enviroment:\n\n\n\n");
    timprature_humidity_contractor();// measruing the temprature and humidity.
    pc.printf("Sending WiFi information to \n");
    blue.printf("Sending WiFi information to \n");
    wifi_send();
    greenled=1; // when the motion detected turn of the on board red led
    LED.period(2); // 2 seconds period
    wait(2);
    LED.pulsewidth(.02);    // 2 mseconds pulse (on)
    greenled=1;
    Buzzer = 1;
    wait(2);


         }
          
    else {
         
         pc.printf(" The Sensor is OFF \r\n");
         blue.printf(" The Sensor is OFF \r\n");
         LED = 0;
         Buzzer =0;
         greenled=0; // turn the on board red led on
         wait(2);
         }
    } 
  }
  
void wifi_send()
{
   
  //WIFI updates the Status to Thingspeak servers//
  strcpy(snd,"AT+CIPMUX=1");//Setting WiFi into MultiChannel mode
  wifi.SendCMD(snd);
  pc.printf(snd);
  blue.printf(snd);
  wait(2);
  wifi.RcvReply(rcv, 1000);
  pc.printf("%s", rcv);
  blue.printf("%s", rcv);
  wait(2);
  sprintf(snd,"AT+CIPSTART=4,\"TCP\",\"%s\",80",IP); //Initiate connection with THINGSPEAK server 
  pc.printf(snd);
  blue.printf(snd);
  wait(3);
  wifi.RcvReply(rcv, 1000);
  pc.printf("%s", rcv);
  blue.printf("%s", rcv);
  wait(2);
  strcpy(snd,"AT+CIPSEND=4,47");    //Send Number of open connections,Characters to send 
  wifi.SendCMD(snd);
  pc.printf(snd);
  blue.printf(snd);
  wait(2.0);
  wifi.RcvReply(rcv, 1000);
  wait(2); 
  pc.printf("%s", rcv);
  blue.printf("%s", rcv);
  wait(2);    
  pc.printf("%s",snd); 
  blue.printf("%s",snd); 
  sprintf(snd,"GET https://api.thingspeak.com/update?key=7PPRUQANXEJ0UURH&feild1=2 HTTP/1.0 \r\n\r\n"); //post it
  pc.printf("%s",snd);
  blue.printf("%s",snd);
  wifi.SendCMD(snd);
  wait(3);
  wifi.RcvReply(rcv, 1000);
  pc.printf("%s", rcv);
  blue.printf("%s", rcv);
  wifi.SendCMD("AT+CIPCLOSE"); //Close the connection to server
  wifi.RcvReply(rcv, 1000);
  pc.printf("%s", rcv);
  blue.printf("%s", rcv);
}

float timprature_humidity_contractor()
{
    int error = 0;
    float h =0 , c =0, f = 0 , k = 0, dp = 0, dpf = 0;  // clear sensor variable for new data place

     for ( myclock=0; myclock < max_clock; myclock ++ ) //while(1) 
    {
        wait(2);
        error = sensor.readData();
        // 
        if (error ==0 ) {
            ledred=0;
            LED=1;
            
            // censior variales are assigned from the sensoor reading 
            // and after the reading celcius to farenheit equvallent qalqucaltion.
            
            c   = sensor.ReadTemperature(CELCIUS);
            f   = sensor.ReadTemperature(FARENHEIT);
            k   = sensor.ReadTemperature(KELVIN);
            h   = sensor.ReadHumidity();
            dp  = sensor.CalcdewPoint(c, h);
            dpf = sensor.CalcdewPointFast(c, h);
            
            outside_green_led = 1; // toggle pin
            ledgreen = 1;//ledgreen=1;
            wait(2);
            
        printf(" \n\n AM2 302 tmp/Hmd sensro device is giving with:%d precsion \n", error);
        printf(" ===========HERE IS THE  DATA YOU MAY WANT============\n " );
            
            printf("Temperature in Kelvin:   %5.2f \n", k );
            printf("Temprature in  Celcius:  %5.2f \n", c );
            printf("Temprature in Farenheit %5.2f \n",  f);
            printf("Humidity is :  %6.2f \n",h);
            printf("Dew Point is : %6.2f  \n",dp);
            printf("Dew Pointvfastv is %6.2f \n ",dpf);
            printf("--wait for the NEXT reading please.\n\n\n\n\n\n");
            //*********************blue 
            blue.printf(" \n\n AM2 302 tmp/Hmd sensro device is giving with:%d precsion \n", error);
            blue.printf(" ===========HERE IS THE  DATA YOU MAY WANT============\n " );
            
            blue.printf("Temperature in Kelvin:   %5.2f \n", k );
            blue.printf("Temprature in  Celcius:  %5.2f \n", c );
            blue.printf("Temprature in Farenheit %5.2f \n",  f);
            blue.printf("Humidity is  :  %6.2f  \n",h);
            blue.printf("Dew Point is :  %6.2f  \n",dp);
            blue.printf("Dew Pointvfastv is %6.2f \n ",dpf);
            blue.printf("...wait for the NEXT reading please.\n\n\n\n\n\n");
            
            
            
        } 
        else {
            ledgreen=0;
            ledred=1;// ledred = 1; // toggle led
            wait(2);
            printf(" Error value ( offset measured) is : %d\n", error);
            printf(" wait: Device is calbrating for good reading \n\n\n\n\n");
            printf("*****************************\n");
            //********************blue
            blue.printf(" Error value ( offset measured) is : %d\n", error);
            blue.printf(" wait: Device is calbrating for good reading \n\n\n\n\n");
            blue.printf("*****************************\n");
            
            
        }
    }
    return c;
    // dpf;
    //return dp;
}

