#include <vector>
#include "mbed.h"

//used for x,y coordinates
struct Pair {
    double x;
    double y;  
};

class Enemy{
private:

public:
    bool moved;
    Pair spawn;
    Pair speed;
    Pair coord;
    Pair old_coord;
    Pair size;    
 
//Enemies take in a spawn locatio (x,y) and a speed(x,y) 
Enemy(Pair tSpawn, Pair tSpeed) :  moved(false)
{
    spawn = tSpawn;
    speed = tSpeed;
    coord = tSpawn;
    old_coord = coord;
    size.x = 5;
    size.y = 7;    
}

//Enemies move by updating their location based on their speed
//if they hit a left/right wall their x speed is reversed
void move(){ 
    old_coord = coord;
    moved = true;
    coord.x = coord.x + speed.x;
    coord.y = coord.y + speed.y;
    if (coord.x <= 0) {
        coord.x = 0;
        speed.x = -speed.x;
    }
    else if (coord.x >= 128-size.x) {
      coord.x = 128-size.x;
      speed.x = -speed.x;
    }  
}
};

//What the ship shoots
class Bullet{
private:

public:
    bool moved;
    Pair old_coord;
    Pair coord;
    Pair size;
    
Bullet(Pair tCoord) : moved(false)
{
    coord = tCoord;
    //old_coord = coord;
    size.x = 3;
    size.y = 3;
}
//Can only move up
void move(){ 
    old_coord = coord;
    moved = true;
    coord.y = coord.y - 5;
}
};

//What you control
class Ship{
private:
public:
    bool moved;
    Pair coord;
    Pair old_coord;
    Pair size;
//Always starts in the center of the screen at the bottom
Ship() : moved(false)
{
    size.x = 10;
    size.y = 5;
    coord.x = (128/2)-size.x;
    coord.y = 128-size.y;
    old_coord = coord;
}
};