#define MQTTCLIENT_QOS2 0
//#define IAP_LOCATION 0x1FFF1FF1
#define HTTP

#include "ESP8266.h"
#include "ESP8266Interface.h"
#include "MQTTNetwork.h"
#include "MQTTmbed.h"
#include "MQTTClient.h"
#include "TCPSocket.h"
#include "IAP.h"
#include "stdlib.h"
#include "time.h"
#include "TextLCD.h"

TextLCD lcd(p6,p8,p25,p26,p27,p28, TextLCD::LCD16x2);
//TextLCD lcd(p15,p16,p17,p18,p19,p20, TextLCD::LCD16x2);
//ESP8266Interface wifi(p28, p27);
ESP8266Interface wifi(p13, p14);
char* salted_id;
Timer timer;
//unsigned int iap_out[10];

void messageArrived(MQTT::MessageData& md) {
    timer.stop();
    MQTT::Message &message = md.message;
    char* number;
    lcd.cls();
    lcd.locate(0,0);
    printf("Message arrived: qos %d , packet id: %d\n", message.qos, message.id);
    printf("Payload %.*s\n", message.payloadlen, (char*)message.payload);
    salted_id = strtok((char *)message.payload, "-");
    number = strtok(NULL, "\0");
   // printf("number is %s\n", number);
    
//    ++arrivedcount;
//    lcd.printf((char*)message.payload);
   // lcd.puts((char*)message.payload);
    lcd.puts((char*)salted_id);
    lcd.locate(0,1);
    lcd.puts((char*)number);
    
    
}

void GET(NetworkInterface *net, const char * address, const char * argument, int portnum)
{
    //TCPSocket socket;
    TCPSocket socket;
    printf("Sending HTTP request to %s:%d/\r\n", address, portnum);

    // Open a socket on the network interface, and create a TCP connection to www.arm.com
     int ret = socket.open(net);
    printf("socket open returns %d\n", ret);
    ret = socket.connect(address, portnum);
    printf("socket connect returns %d\n", ret);
    while (ret < 0) {
        ret = socket.connect(address, portnum);
    printf("socket connect returns %d\n", ret);
    }       

    // Send a simple http request
    char sbuffer[1024]; 
    sprintf(sbuffer, "GET / HTTP/1.1\r\nHost: %s\r\n\r\n", address);

while(1) {
    
    int scount = socket.send(sbuffer, sizeof sbuffer);
    printf("sent %d [%.*s]\r\n", scount, strstr(sbuffer, "\r\n")-sbuffer, sbuffer);
    printf("-->%s\r\n", sbuffer);
    // Recieve a simple http response and print out the response line
    char rbuffer[1024];
    int rcount = socket.recv(rbuffer, sizeof rbuffer);
    printf("recv %d %s\r\n", rcount, rbuffer);
}
    // Close the socket to return its memory and bring down the network interface
    socket.close();
}

int initConnection(const char * SSID, const char * password)
{
    printf("WiFi example\r\n\r\n");

    // Scan for available access points 
  //  scan_demo(&wifi);

    printf("\r\nConnecting...\r\n");
    int ret = wifi.connect(SSID, password);
    if (ret != 0) {
        printf("\r\nConnection error\r\n");
        return -1;
    }

    printf("Success\r\n\r\n");
    printf("MAC: %s\r\n", wifi.get_mac_address());
    printf("IP: %s\r\n", wifi.get_ip_address());
    printf("Netmask: %s\r\n", wifi.get_netmask());
    printf("Gateway: %s\r\n", wifi.get_gateway());
    printf("RSSI: %d\r\n\r\n", wifi.get_rssi());

    //GET(&wifi, "upenn.pennpacapp.com", "1");
    //GET(&wifi, "192.168.8.1", "Testing|testing|1|2|3");
}


int main(int argc, char* argv[]) {
    int ret;
    
    //Define host name/ identification
    //const char *hostname = "192.168.4.1";
        //const char *hostname = "35.196.225.7";
    const char *hostname = "192.168.43.138";
    char topic[100];
    char subscription_topic[100];
    char id[8];
    char deviceID[33];
    char uuid[45];
    int portnum = 8087;

    IAP iap;
    
    unsigned int iap_out;
    iap_out = iap.read_ID();
    
    int *iap_serial = (int *)malloc(sizeof(int) * 4);
    iap_serial = iap.read_serial();
    
 
   #ifdef DEBUG_PRINT
    printf("IAP output is %08x\n",iap_out);
    printf("IAP output is %08x\n", *(iap_serial));
    printf("IAP output is %08x\n", *(iap_serial+ 1));
    printf("IAP output is %08x\n", *(iap_serial+ 2));
    printf("IAP output is %08x\n", *(iap_serial+ 3));
    printf("size of int is %d\n", sizeof(int));
    #endif
    
    sprintf(id, "%08x", iap_out);
    sprintf(deviceID, "%08x%08x%08x%08x", *(iap_serial),*(iap_serial + 1),*(iap_serial+ 2),*(iap_serial+ 3));
    sprintf(uuid, "%8s-%32s", id, deviceID);
    printf("uuid: %s\n", uuid);
    sprintf(topic, "cis541/hw-mqtt/%s/data", uuid);
    printf("topic: %s\n", topic);
    sprintf(subscription_topic, "cis541/hw-mqtt/%s/echo", uuid);
    printf("subscribe topic: %s\n", subscription_topic);
    
 #ifdef MQTT   
    MQTTNetwork mqttnw(&wifi);
    MQTT::Client<MQTTNetwork, Countdown> client(mqttnw);
#endif

    //initConnection("Aspire-E5-573G", "03fee30fde");
    //initConnection("Pi_Network", "warehouse");    
    initConnection("OnePlus3", "magnasift");
    //Specify network parameters
    
  /*
    wifi.set_credentials(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, NSAPI_SECURITY_WPA_WPA2);
    ret = wifi.connect();
    if(ret < 0) {
        printf("Error in connecting to AP \n");    
    }
    
        printf("IP address is %s \n", wifi.get_ip_address());    
    
  */
  
  
  
 #ifdef MQTT   
    //Establish connection
    ret = mqttnw.connect(hostname, portnum);
    if(ret < 0) {
        printf("Error in connecting to mqttnw ret: %d\n", ret);    
    }
    
     MQTTPacket_connectData data = MQTTPacket_connectData_initializer;  
 //    connackData connData;
     data.clientID.cstring = uuid;
     data.username.cstring = "mbed";
     data.password.cstring = "homework";
    
    ret = client.connect(data);
    if(ret < 0) {
        printf("Error in connecting to MQTT server at %s, ret i %d\n", hostname, ret);    
    }
  
    ret = client.subscribe(subscription_topic, MQTT::QOS0, messageArrived);
    if(ret < 0) {
        printf("Client did not subscribe to topic %s, ret is %d\n", subscription_topic, ret);    
    }
    printf("client subscribe ret is %d\n", ret);
    
    int count = 0;
    //Create a message in buffer
    char msgbuf[20] = "Test Data";
    int rand_num;
    MQTT::Message message;
    message.qos = MQTT::QOS1;
    message.retained = false;
    message.dup = false;
    
    while(1) {
        
        //rand_num = 5 * (count % 20);
        rand_num = rand() % 100;
//        printf("rand_num %02d\n", rand_num);
        sprintf(msgbuf, "%02d", rand_num);
        message.payload = (void*)msgbuf;
        message.payloadlen = strlen(msgbuf)+1;  
        ret = client.publish(topic, message);  
        timer.reset();  
        timer.start();
    
        if(ret != 0) {
            printf("Client publish failure %d\n", ret);    
        } else {
            printf("Client publish successful %d\n", ret);    
        }
        client.yield(1000);
     
        wait(4);
        printf("Timer observed value is %f\n", timer.read());   
    }
    
    client.unsubscribe(subscription_topic);
    client.disconnect();
#endif
  
#ifdef HTTP   
    GET(&wifi, hostname, "", portnum);
    printf("End of GET\n");
#endif 

    return 0;
}